/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.server.SerializableFunction;
import com.vaadin.ui.Component;

/**
 * A callback interface for generating details for a particular row in Grid.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @param <T>
 *            the grid bean type
 */
@FunctionalInterface
public interface DetailsGenerator<T>
        extends SerializableFunction<T, Component> {
}
