/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.event.SerializableEventListener;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Grid.ItemClick;

/**
 * A listener for item click events.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @param <T>
 *            the grid bean type
 *
 * @see ItemClick
 * @see Registration
 */
@FunctionalInterface
public interface ItemClickListener<T> extends SerializableEventListener {
    /**
     * Invoked when this listener receives a item click event from a Grid to
     * which it has been added.
     *
     * @param event
     *            the received event, not null
     */
    public void itemClick(Grid.ItemClick<T> event);
}
