/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4);
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.shared.data;

import com.vaadin.shared.communication.ClientRpc;

/**
 * RPC interface used by HierarchicalDataProvider to send data to the
 * client-side. Used in addition to {@link DataCommunicatorClientRpc}.
 *
 * @since 8.18
 */
public interface HierarchicalDataCommunicatorClientRpc extends ClientRpc {

    /**
     * Set {@code true} when the client-side DataSource needs to be aware that
     * there is one or more expand or collapse call affecting the cache within
     * this round trip, and {@code false} when all expand or collapse changes
     * have already been sent.
     *
     * @param pending
     *            {@code true} before the updates, {@code false} when all the
     *            updates are done
     */
    void setExpandCollapsePending(boolean pending);
}
