/*
 * Copyright 2000-2022 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4);
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.shared.ui;

import com.vaadin.shared.communication.ServerRpc;

/**
 * Delayed callback RPC interface.
 * <p>
 * Notifies the UI when a round-trip has been completed after a delayed callback
 * has been registered.
 *
 * @author Vaadin Ltd
 * @since 8.18
 */
public interface DelayedCallbackRpc extends ServerRpc {

    /**
     * Mark the round-trip completed for all the pending delayed callbacks up to
     * the given one.
     *
     * @param latestDelayedID
     *            the latest ID for a delayed callback.
     */
    public void received(long latestDelayedID);
}
