/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.resources;

/**
 * Used to declare a Vaadin Theme for use in OSGi. The theme is expected to be
 * in the same OSGi bundle as the class implementing this interface, under the
 * path "/VAADIN/themes/{themeName}" where {themeName} is what is returned by
 * {@link OsgiVaadinTheme#getName()}.
 * <p>
 * To publish a theme, an implementation of this interface needs to be
 * registered as an OSGi service, which makes
 * <code>VaadinResourceTrackerComponent</code> automatically publish the theme
 * with the given name.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.1
 */
public interface OsgiVaadinTheme extends OsgiVaadinResource {
    /**
     * Return the theme name to publish for OSGi.
     *
     * @return theme name, not null
     */
    @Override
    public String getName();

    public static OsgiVaadinTheme create(final String name) {
        return new OsgiVaadinTheme() {
            @Override
            public String getName() {
                return name;
            }
        };
    }
}
