/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

import java.util.List;
import java.util.Map;

import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.communication.ServerRpc;

/**
 * RPC for firing server side drop event when client side drop event happens on
 * drop target.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public interface DropTargetRpc extends ServerRpc {

    /**
     * Called when drop event happens on client side.
     *
     * @param types
     *            List of data types from {@code DataTransfer.types} object.
     * @param data
     *            Map containing all types and corresponding data from the
     *            {@code
     *         DataTransfer} object.
     * @param dropEffect
     *            The desired drop effect.
     * @param mouseEventDetails
     *            mouse event details object containing information about the
     *            drop event
     */
    public void drop(List<String> types, Map<String, String> data,
            String dropEffect, MouseEventDetails mouseEventDetails);
}
