/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.dnd;

import java.util.ArrayList;
import java.util.List;

import com.vaadin.shared.communication.SharedState;
import com.vaadin.shared.ui.dnd.criteria.Criterion;

/**
 * State class containing parameters for DropTargetExtension.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public class DropTargetState extends SharedState {
    /**
     * {@code DataTransfer.dropEffect} parameter for the drag event.
     */
    public DropEffect dropEffect;

    /**
     * Criteria script to allow drop event on the element.
     */
    public String criteriaScript;

    /**
     * List of criteria to compare against the payload.
     */
    public List<Criterion> criteria = new ArrayList<>();

    /**
     * Declares whether any or all of the given criteria should match the
     * payload.
     */
    public Criterion.Match criteriaMatch = Criterion.Match.ANY;
}
