/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid;

import com.vaadin.shared.ui.dnd.DropTargetState;

/**
 * State class containing parameters for GridDropTarget.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public class GridDropTargetState extends DropTargetState {

    /**
     * Stores the drop mode of the drop target Grid.
     */
    public DropMode dropMode;

    /**
     * Stores the threshold between drop locations within a row in pixels.
     * Defaults to 5px.
     *
     * @see DropMode#ON_TOP_OR_BETWEEN
     */
    public int dropThreshold = 5;

}
