/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.textfield;

import com.vaadin.shared.communication.ClientRpc;

/**
 * Server to client RPC interface for AbstractTextField.
 *
 * @since 8.0
 */
public interface AbstractTextFieldClientRpc extends ClientRpc {
    /**
     * Selects the given range in the field.
     *
     * @param start
     *            the start of the range
     * @param length
     *            the length to select
     */
    void selectRange(int start, int length);

    /**
     * Selects everything in the field.
     */
    void selectAll();
}
