/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.data.selection;

/**
 * Transmits selection events for grid multiselection model to server side.
 *
 * @since 8.0
 * @author Vaadin Ltd.
 *
 */
public interface GridMultiSelectServerRpc extends SelectionServerRpc {
    /**
     * All rows in grid have been selected with the select all checkbox in
     * header.
     */
    public void selectAll();

    /**
     * All rows in grid have been deselected with the select all checkbox in
     * header.
     * <p>
     * This can happen only if the all the rows were previously selected.
     */
    public void deselectAll();
}
