/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.splitpanel;

import java.io.Serializable;

import com.vaadin.shared.Connector;
import com.vaadin.shared.ui.AbstractComponentContainerState;

public class AbstractSplitPanelState extends AbstractComponentContainerState {
    public Connector firstChild = null;
    public Connector secondChild = null;
    public SplitterState splitterState = new SplitterState();

    public static class SplitterState implements Serializable {
        public float position;
        public String positionUnit;
        public float minPosition;
        public String minPositionUnit;
        public float maxPosition;
        public String maxPositionUnit;
        public boolean positionReversed = false;
        public boolean locked = false;
    }
}
