/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid;

/**
 * Defines drop locations within a Grid row.
 *
 * @author Vaadin Ltd.
 * @since 8.1
 */
public enum DropLocation {

    /**
     * Drop on top of the row.
     */
    ON_TOP,

    /**
     * Drop above or before the row.
     */
    ABOVE,

    /**
     * Drop below or after the row.
     */
    BELOW,

    /**
     * Dropping into an empty grid, to a sorted grid, when
     * {@link DropMode#ON_GRID} is used, or to the empty area below the grid
     * rows when {@link DropMode#ON_TOP} is used.
     */
    EMPTY;
}
