/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared;

import com.vaadin.shared.ui.TabIndexState;

/**
 * State for components that can show the required indicator.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 */
public class AbstractFieldState extends TabIndexState {

    /**
     * Is the required indicator visible or not.
     */
    public boolean required = false;

    /**
     * Is the field read-only or not.
     */
    public boolean readOnly = false;

}
