/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.treegrid;

import com.vaadin.shared.ui.grid.GridState;

/**
 * The shared state for the {@link com.vaadin.ui.TreeGrid} component.
 *
 * @since 8.1
 * @author Vaadin Ltd
 */
public class TreeGridState extends GridState {

    {
        primaryStyleName = "v-treegrid";
    }

    /**
     * Contains ID of the hierarchy column set by the developer.
     */
    public String hierarchyColumnId;
}
