/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.shared.ui.ui;

import com.vaadin.shared.communication.ClientRpc;

/**
 * Client side rpc class for Page / UI.
 *
 * @author Vaadin Ltd
 * @since 7.0
 */
public interface PageClientRpc extends ClientRpc {

    /**
     * Reloads the page.
     */
    public void reload();

    /**
     * Initialize Mobile HTML5 Drag and Drop Polyfill.
     *
     * @since 8.1
     */
    public void initializeMobileHtml5DndPolyfill();
}
