/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.data;

import com.vaadin.shared.communication.ClientRpc;

/**
 * RPC interface used by HierarchicalDataProvider to send data to the
 * client-side. Used in addition to {@link DataCommunicatorClientRpc}.
 *
 * @since 8.18
 */
public interface HierarchicalDataCommunicatorClientRpc extends ClientRpc {

    /**
     * Set {@code true} when the client-side DataSource needs to be aware that
     * there is one or more expand or collapse call affecting the cache within
     * this round trip, and {@code false} when all expand or collapse changes
     * have already been sent.
     *
     * @param pending
     *            {@code true} before the updates, {@code false} when all the
     *            updates are done
     */
    void setExpandCollapsePending(boolean pending);
}
