/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.upload;

import com.vaadin.shared.AbstractComponentState;
import com.vaadin.shared.annotations.DelegateToWidget;
import com.vaadin.shared.annotations.NoLayout;

/**
 * Shared state for the Upload component.
 *
 * @since 7.6
 */
public class UploadState extends AbstractComponentState {

    /** Is the upload component in immediate mode or not. */
    public boolean immediateMode = true;

    {
        primaryStyleName = "v-upload";
    }

    /** Upload component's list of accepted content-types. */
    @DelegateToWidget
    @NoLayout
    public String acceptMimeTypes;

    /** Caption of the button that fires uploading. */
    public String buttonCaption = "Upload";

    /** Style name of the button that fires uploading. */
    public String buttonStyleName = "v-button";

    /**
     * Should the caption of the button that fires uploading be rendered as
     * HTML.
     */
    public boolean buttonCaptionAsHtml;
}
