/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasSuffix;
import com.vaadin.flow.component.sidenav.ExperimentalFeatureException;
import com.vaadin.flow.component.sidenav.SideNavItemContainer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;

@Tag(value="vaadin-side-nav-item")
@NpmPackage(value="@vaadin/side-nav", version="24.1.0")
@JsModule(value="@vaadin/side-nav/src/vaadin-side-nav-item.js")
public class SideNavItem
extends SideNavItemContainer
implements HasPrefix,
HasSuffix {
    private Element labelElement;

    public SideNavItem(String label) {
        this.setLabel(label);
    }

    public SideNavItem(String label, String path) {
        this.setPath(path);
        this.setLabel(label);
    }

    public SideNavItem(String label, Class<? extends Component> view) {
        this.setPath(view);
        this.setLabel(label);
    }

    public SideNavItem(String label, String path, Component prefixComponent) {
        this.setPath(path);
        this.setLabel(label);
        this.setPrefixComponent(prefixComponent);
    }

    public SideNavItem(String label, Class<? extends Component> view, Component prefixComponent) {
        this.setPath(view);
        this.setLabel(label);
        this.setPrefixComponent(prefixComponent);
    }

    @Override
    protected void setupSideNavItem(SideNavItem item) {
        item.getElement().setAttribute("slot", "children");
    }

    public String getLabel() {
        return this.labelElement == null ? null : this.labelElement.getText();
    }

    public void setLabel(String label) {
        if (label == null) {
            this.removeLabelElement();
        } else {
            if (this.labelElement == null) {
                this.labelElement = this.createAndAppendLabelElement();
            }
            this.labelElement.setText(label);
        }
    }

    private Element createAndAppendLabelElement() {
        Element element = Element.createText((String)"");
        this.getElement().appendChild(new Element[]{element});
        return element;
    }

    private void removeLabelElement() {
        if (this.labelElement != null) {
            this.getElement().removeChild(new Element[]{this.labelElement});
            this.labelElement = null;
        }
    }

    public void setPath(String path) {
        if (path == null) {
            this.getElement().removeAttribute("path");
        } else {
            this.getElement().setAttribute("path", path);
        }
    }

    public void setPath(Class<? extends Component> view) {
        if (view != null) {
            Router router = ComponentUtil.getRouter((HasElement)this);
            String url = RouteConfiguration.forRegistry((RouteRegistry)router.getRegistry()).getUrl(view);
            this.setPath(url);
        } else {
            this.setPath((String)null);
        }
    }

    public String getPath() {
        return this.getElement().getAttribute("path");
    }

    public void setExpanded(boolean expanded) {
        this.getElement().setProperty("expanded", expanded);
    }

    @Synchronize(property="expanded", value={"expanded-changed"})
    public boolean isExpanded() {
        return this.getElement().getProperty("expanded", false);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.checkFeatureFlag();
    }

    private void checkFeatureFlag() {
        boolean enabled = this.getFeatureFlags().isEnabled(FeatureFlags.SIDE_NAV_COMPONENT);
        if (!enabled) {
            throw new ExperimentalFeatureException();
        }
    }

    protected FeatureFlags getFeatureFlags() {
        return FeatureFlags.get((VaadinContext)UI.getCurrent().getSession().getService().getContext());
    }
}

