/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav;

import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.sidenav.SideNavItemContainer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JsonSerializer;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vaadin-side-nav")
@NpmPackage(value="@vaadin/side-nav", version="24.6.7")
@JsModule(value="@vaadin/side-nav/src/vaadin-side-nav.js")
public class SideNav
extends SideNavItemContainer
implements HasSize,
HasStyle {
    private Element labelElement;
    private SideNavI18n i18n;

    public SideNav() {
    }

    public SideNav(String label) {
        this.setLabel(label);
    }

    public String getLabel() {
        return this.labelElement == null ? null : this.labelElement.getText();
    }

    public void setLabel(String label) {
        if (label == null) {
            this.removeLabelElement();
        } else {
            if (this.labelElement == null) {
                this.labelElement = this.createAndAppendLabelElement();
            }
            this.labelElement.setText(label);
        }
    }

    private Element createAndAppendLabelElement() {
        Element element = new Element("span");
        element.setAttribute("slot", "label");
        this.getElement().appendChild(new Element[]{element});
        return element;
    }

    private void removeLabelElement() {
        if (this.labelElement != null) {
            this.getElement().removeChild(new Element[]{this.labelElement});
            this.labelElement = null;
        }
    }

    public boolean isCollapsible() {
        return this.getElement().getProperty("collapsible", false);
    }

    public void setCollapsible(boolean collapsible) {
        this.getElement().setProperty("collapsible", collapsible);
    }

    @Synchronize(property="collapsed", value={"collapsed-changed"})
    public boolean isExpanded() {
        return !this.getElement().getProperty("collapsed", false);
    }

    public void setExpanded(boolean expanded) {
        this.getElement().setProperty("collapsed", !expanded);
    }

    public SideNavI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(SideNavI18n i18n) {
        Objects.requireNonNull(i18n, "The i18N properties object should not be null");
        this.i18n = i18n;
        this.getElement().setPropertyJson("i18n", JsonSerializer.toJson((Object)i18n));
    }

    public static class SideNavI18n
    implements Serializable {
        private String toggle;

        public String getToggle() {
            return this.toggle;
        }

        public SideNavI18n setToggle(String toggle) {
            this.toggle = toggle;
            return this;
        }
    }
}

