/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.splitlayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.splitlayout.GeneratedVaadinSplitLayout;
import com.vaadin.flow.component.splitlayout.SplitLayoutVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

@NpmPackage.Container(value={@NpmPackage(value="@vaadin/split-layout", version="23.5.1"), @NpmPackage(value="@vaadin/vaadin-split-layout", version="23.5.1")})
public class SplitLayout
extends GeneratedVaadinSplitLayout<SplitLayout>
implements HasSize {
    private Component primaryComponent;
    private Component secondaryComponent;
    private StateTree.ExecutionRegistration updateStylesRegistration;
    private Double splitterPosition;

    public SplitLayout() {
        this.setOrientation(Orientation.HORIZONTAL);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.requestStylesUpdatesForSplitterPosition(e.getUI()));
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent) {
        this();
        this.addToPrimary(primaryComponent);
        this.addToSecondary(secondaryComponent);
    }

    public SplitLayout(Orientation orientation) {
        this.setOrientation(orientation);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.requestStylesUpdatesForSplitterPosition(e.getUI()));
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent, Orientation orientation) {
        this(primaryComponent, secondaryComponent);
        this.setOrientation(orientation);
    }

    public void setOrientation(Orientation orientation) {
        Objects.requireNonNull(orientation, "Orientation cannot be null");
        this.setOrientation(orientation.toString().toLowerCase(Locale.ENGLISH));
    }

    public Orientation getOrientation() {
        return Orientation.valueOf(super.getOrientationString().toUpperCase());
    }

    @Override
    public void addToPrimary(Component ... components) {
        this.primaryComponent = this.getComponentOrWrap(components);
        this.setComponent(this.primaryComponent, "primary");
    }

    public Component getPrimaryComponent() {
        return this.primaryComponent;
    }

    @Override
    public void addToSecondary(Component ... components) {
        this.secondaryComponent = this.getComponentOrWrap(components);
        this.setComponent(this.secondaryComponent, "secondary");
    }

    public Component getSecondaryComponent() {
        return this.secondaryComponent;
    }

    public void setSplitterPosition(double position) {
        this.splitterPosition = position;
        this.getUI().ifPresent(this::requestStylesUpdatesForSplitterPosition);
    }

    private void requestStylesUpdatesForSplitterPosition(UI ui) {
        if (this.updateStylesRegistration != null) {
            this.updateStylesRegistration.remove();
        }
        this.updateStylesRegistration = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            this.updateStylesForSplitterPosition();
            this.updateStylesRegistration = null;
        });
    }

    private void updateStylesForSplitterPosition() {
        if (this.splitterPosition == null) {
            return;
        }
        double primary = Math.min(Math.max(this.splitterPosition, 0.0), 100.0);
        double secondary = 100.0 - primary;
        this.setPrimaryStyle("flex", String.format("1 1 %s%%", primary));
        this.setSecondaryStyle("flex", String.format("1 1 %s%%", secondary));
    }

    public void setPrimaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, true);
    }

    public void setSecondaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, false);
    }

    private Component getComponentOrWrap(Component ... components) {
        return components.length == 1 ? components[0] : new Div(components);
    }

    private void setComponent(Component component, String slot) {
        this.getElement().getChildren().filter(node -> slot.equals(node.getAttribute("slot"))).forEach(node -> {
            node.removeAttribute("slot");
            this.getElement().removeChild(new Element[]{node});
        });
        component.getElement().setAttribute("slot", slot);
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    @Override
    public void remove(Component ... components) {
        super.remove(components);
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }

    @Override
    public Registration addSplitterDragendListener(ComponentEventListener<SplitterDragendEvent<SplitLayout>> listener) {
        return super.addSplitterDragendListener(listener);
    }

    private void setInnerComponentStyle(String styleName, String value, boolean primary) {
        Component innerComponent;
        Component component = innerComponent = primary ? this.primaryComponent : this.secondaryComponent;
        if (innerComponent != null) {
            innerComponent.getElement().executeJs("this.style[$0]=$1", new Serializable[]{styleName, value});
        } else {
            this.getElement().executeJs("var element = this.children[$0]; if (element) { element.style[$1]=$2; }", new Serializable[]{Integer.valueOf(primary ? 0 : 1), styleName, value});
        }
    }

    @Override
    public void addThemeVariants(SplitLayoutVariant ... variants) {
        super.addThemeVariants(variants);
    }

    @Override
    public void removeThemeVariants(SplitLayoutVariant ... variants) {
        super.removeThemeVariants(variants);
    }

    public static class SplitterDragendEvent<T extends GeneratedVaadinSplitLayout<T>>
    extends GeneratedVaadinSplitLayout.SplitterDragendEvent<T> {
        public SplitterDragendEvent(T source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

