/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.splitlayout;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.splitlayout.SplitLayoutVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

@Tag(value="vaadin-split-layout")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.4.9"), @NpmPackage(value="@vaadin/split-layout", version="24.4.9")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/split-layout/src/vaadin-split-layout.js")})
public class SplitLayout
extends Component
implements ClickNotifier<SplitLayout>,
HasSize,
HasStyle,
HasThemeVariant<SplitLayoutVariant> {
    private Component primaryComponent;
    private Component secondaryComponent;
    private StateTree.ExecutionRegistration updateStylesRegistration;
    private Double splitterPosition;

    public SplitLayout() {
        this(Orientation.HORIZONTAL);
    }

    public SplitLayout(Orientation orientation) {
        this.setOrientation(orientation);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.requestStylesUpdatesForSplitterPosition(e.getUI()));
        this.addSplitterDragendListener((ComponentEventListener<SplitterDragendEvent>)(ComponentEventListener & Serializable)e -> {
            this.splitterPosition = this.calcNewSplitterPosition(e.primaryComponentFlexBasis, e.secondaryComponentFlexBasis);
            this.setPrimaryStyle("flex", String.format("1 1 %s", e.primaryComponentFlexBasis));
            this.setSecondaryStyle("flex", String.format("1 1 %s", e.secondaryComponentFlexBasis));
        });
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent) {
        this(primaryComponent, secondaryComponent, Orientation.HORIZONTAL);
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent, Orientation orientation) {
        this(orientation);
        this.addToPrimary(primaryComponent);
        this.addToSecondary(secondaryComponent);
    }

    public void setOrientation(Orientation orientation) {
        Objects.requireNonNull(orientation, "Orientation cannot be null");
        this.getElement().setProperty("orientation", orientation.toString().toLowerCase(Locale.ENGLISH));
    }

    public Orientation getOrientation() {
        String orientation = this.getElement().getProperty("orientation");
        return Orientation.valueOf(orientation.toUpperCase());
    }

    public void addToPrimary(Component ... components) {
        this.primaryComponent = this.getComponentOrWrap(components);
        this.setComponent(this.primaryComponent, "primary");
    }

    public Component getPrimaryComponent() {
        return this.primaryComponent;
    }

    public void addToSecondary(Component ... components) {
        this.secondaryComponent = this.getComponentOrWrap(components);
        this.setComponent(this.secondaryComponent, "secondary");
    }

    public Component getSecondaryComponent() {
        return this.secondaryComponent;
    }

    public Double getSplitterPosition() {
        return this.splitterPosition;
    }

    public void setSplitterPosition(double position) {
        this.splitterPosition = position;
        this.getUI().ifPresent(this::requestStylesUpdatesForSplitterPosition);
    }

    private void requestStylesUpdatesForSplitterPosition(UI ui) {
        if (this.updateStylesRegistration != null) {
            this.updateStylesRegistration.remove();
        }
        this.updateStylesRegistration = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            this.updateStylesForSplitterPosition();
            this.updateStylesRegistration = null;
        });
    }

    private void updateStylesForSplitterPosition() {
        if (this.splitterPosition == null) {
            return;
        }
        double primary = Math.min(Math.max(this.splitterPosition, 0.0), 100.0);
        double secondary = 100.0 - primary;
        this.setPrimaryStyle("flex", String.format("1 1 %s%%", primary));
        this.setSecondaryStyle("flex", String.format("1 1 %s%%", secondary));
    }

    public void setPrimaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, true);
    }

    public void setSecondaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, false);
    }

    private Component getComponentOrWrap(Component ... components) {
        return components.length == 1 ? components[0] : new Div(components);
    }

    private void setComponent(Component component, String slot) {
        Component child = component == null ? new Div() : component;
        SlotUtils.setSlot((HasElement)this, (String)slot, (Component[])new Component[]{child});
    }

    public void remove(Component ... components) {
        for (Component component : components) {
            if (this.getElement().equals((Object)component.getElement().getParent())) {
                if (component.equals(this.primaryComponent)) {
                    this.primaryComponent = null;
                } else if (component.equals(this.secondaryComponent)) {
                    this.secondaryComponent = null;
                }
            } else {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    public void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
        this.primaryComponent = null;
        this.secondaryComponent = null;
    }

    public Registration addSplitterDragendListener(ComponentEventListener<SplitterDragendEvent> listener) {
        return this.addListener(SplitterDragendEvent.class, listener);
    }

    private void setInnerComponentStyle(String styleName, String value, boolean primary) {
        Component innerComponent;
        Component component = innerComponent = primary ? this.primaryComponent : this.secondaryComponent;
        if (innerComponent != null) {
            innerComponent.getElement().getStyle().set(styleName, value);
        } else {
            this.getElement().executeJs("var element = this.children[$0]; if (element) { element.style[$1]=$2; }", new Serializable[]{Integer.valueOf(primary ? 0 : 1), styleName, value});
        }
    }

    private Double calcNewSplitterPosition(String primaryFlexBasis, String secondaryFlexBasis) {
        Double splitterPositionValue = this.splitterPosition;
        if (primaryFlexBasis == null || secondaryFlexBasis == null) {
            return splitterPositionValue;
        }
        if (primaryFlexBasis.endsWith("px")) {
            double pFlexBasis = Double.parseDouble(primaryFlexBasis.replace("px", ""));
            double sFlexBasis = Double.parseDouble(secondaryFlexBasis.replace("px", ""));
            splitterPositionValue = pFlexBasis * 100.0 / (pFlexBasis + sFlexBasis);
            splitterPositionValue = this.round(splitterPositionValue);
        } else if (primaryFlexBasis.endsWith("%")) {
            splitterPositionValue = Double.parseDouble(primaryFlexBasis.replace("%", ""));
            splitterPositionValue = this.round(splitterPositionValue);
        } else {
            throw new IllegalArgumentException("Given flex basis values are not supported: " + primaryFlexBasis + " / " + secondaryFlexBasis);
        }
        return splitterPositionValue;
    }

    private double round(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }

    @DomEvent(value="splitter-dragend")
    public static class SplitterDragendEvent
    extends ComponentEvent<SplitLayout> {
        private static final String PRIMARY_FLEX_BASIS = "element.querySelector(':scope > [slot=\"primary\"]').style.flexBasis";
        private static final String SECONDARY_FLEX_BASIS = "element.querySelector(':scope > [slot=\"secondary\"]').style.flexBasis";
        String primaryComponentFlexBasis;
        String secondaryComponentFlexBasis;

        public SplitterDragendEvent(SplitLayout source, boolean fromClient, @EventData(value="element.querySelector(':scope > [slot=\"primary\"]').style.flexBasis") String primaryComponentFlexBasis, @EventData(value="element.querySelector(':scope > [slot=\"secondary\"]').style.flexBasis") String secondaryComponentFlexBasis) {
            super((Component)source, fromClient);
            this.primaryComponentFlexBasis = primaryComponentFlexBasis;
            this.secondaryComponentFlexBasis = secondaryComponentFlexBasis;
        }
    }
}

