/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.spreadsheet.framework.ReflectTools;
import com.vaadin.flow.component.spreadsheet.rpc.PopupButtonClientRpc;
import com.vaadin.flow.component.spreadsheet.rpc.PopupButtonServerRpc;
import com.vaadin.flow.component.spreadsheet.shared.PopupButtonState;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.apache.poi.ss.util.CellReference;

@Tag(value="div")
public class PopupButton
extends Component
implements HasComponents {
    private PopupButtonServerRpc rpc = new PopupButtonServerRpc(){

        @Override
        public void onPopupClose() {
            PopupButton.this.setPopupVisible(false);
            PopupButton.this.fireClose();
        }

        @Override
        public void onPopupButtonClick() {
            PopupButton.this.setPopupVisible(true);
            PopupButton.this.fireOpen();
        }
    };
    private Component child;
    private boolean popupVisible = false;
    private PopupButtonState state = new PopupButtonState();

    public PopupButton() {
        this.setId(UUID.randomUUID().toString());
        this.registerRpc(this.rpc);
    }

    private void registerRpc(PopupButtonServerRpc rpc) {
        this.rpc = rpc;
    }

    public PopupButton(Component content) {
        this();
        this.child = content;
    }

    public CellReference getCellReference() {
        return new CellReference(this.getState((boolean)false).sheet, this.getState((boolean)false).row - 1, this.getState((boolean)false).col - 1, false, false);
    }

    void setCellReference(CellReference cellReference) {
        this.getState().col = cellReference.getCol() + 1;
        this.getState().row = cellReference.getRow() + 1;
        this.getState().sheet = cellReference.getSheetName();
    }

    public int getColumn() {
        return this.getState((boolean)false).col - 1;
    }

    public int getRow() {
        return this.getState((boolean)false).row - 1;
    }

    public void openPopup() {
        this.setPopupVisible(true);
    }

    private PopupButton getRpcProxy(Class<PopupButtonClientRpc> popupButtonClientRpcClass) {
        return null;
    }

    public void closePopup() {
        this.setPopupVisible(false);
    }

    public boolean isHeaderHidden() {
        return this.getState().headerHidden;
    }

    public void setHeaderHidden(boolean headerHidden) {
        this.getState().headerHidden = headerHidden;
    }

    public void setPopupWidth(String width) {
        this.getState().popupWidth = width;
    }

    public String getPopupWidth() {
        return this.getState().popupWidth;
    }

    public void setPopupHeight(String height) {
        this.getState().popupHeight = height;
    }

    public String getPopupHeight() {
        return this.getState().popupHeight;
    }

    protected PopupButtonState getState() {
        return this.state;
    }

    protected PopupButtonState getState(boolean markAsDirty) {
        return this.state;
    }

    public void setContent(Component content) {
        this.child = content;
    }

    public Component getContent() {
        return this.child;
    }

    public Iterator<Component> iterator() {
        if (this.child != null && this.popupVisible) {
            return Collections.singleton(this.child).iterator();
        }
        return Collections.emptyList().iterator();
    }

    public void markActive(boolean active) {
        this.getState().active = active;
    }

    public boolean isActive() {
        return this.getState().active;
    }

    public void addPopupOpenListener(PopupOpenListener listener) {
        this.addListener(PopupOpenEvent.class, listener::onPopupOpen);
    }

    public void removePopupOpenListener(PopupOpenListener listener) {
        this.removeListener(PopupOpenEvent.class, listener, PopupOpenListener.POPUP_OPEN_METHOD);
    }

    private void removeListener(Class<? extends ComponentEvent> eventClass, Serializable listener, Method method) {
    }

    public void addPopupCloseListener(PopupCloseListener listener) {
        this.addListener(PopupCloseEvent.class, listener::onPopupClose);
    }

    public void removePopupCloseListener(PopupCloseListener listener) {
        this.removeListener(PopupCloseEvent.class, listener, PopupCloseListener.POPUP_CLOSE_METHOD);
    }

    private void fireOpen() {
        this.fireEvent(new PopupOpenEvent(this));
    }

    private void fireClose() {
        this.fireEvent(new PopupCloseEvent(this));
    }

    private void setPopupVisible(boolean visible) {
        this.popupVisible = visible;
    }

    public static interface PopupCloseListener
    extends Serializable {
        public static final Method POPUP_CLOSE_METHOD = ReflectTools.findMethod(PopupCloseListener.class, "onPopupClose", PopupCloseEvent.class);

        public void onPopupClose(PopupCloseEvent var1);
    }

    public static class PopupCloseEvent
    extends ComponentEvent<Component> {
        public PopupCloseEvent(Component source) {
            super(source, false);
        }

        public PopupButton getPopupButton() {
            return (PopupButton)this.getSource();
        }
    }

    public static interface PopupOpenListener
    extends Serializable {
        public static final Method POPUP_OPEN_METHOD = ReflectTools.findMethod(PopupOpenListener.class, "onPopupOpen", PopupOpenEvent.class);

        public void onPopupOpen(PopupOpenEvent var1);
    }

    public static class PopupOpenEvent
    extends ComponentEvent<Component> {
        public PopupOpenEvent(Component source) {
            super(source, false);
        }

        public PopupButton getPopupButton() {
            return (PopupButton)this.getSource();
        }
    }
}

