/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.dataprovider;

import com.vaadin.data.provider.AbstractBackEndDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.shared.data.sort.SortDirection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Pair;

public abstract class PageableDataProvider<T, F>
extends AbstractBackEndDataProvider<T, F> {
    protected Stream<T> fetchFromBackEnd(Query<T, F> query) {
        Pageable pageable = this.getPageable(query);
        Page<T> result = this.fetchFromBackEnd(query, pageable);
        return this.fromPageable(result, pageable, query);
    }

    protected abstract Page<T> fetchFromBackEnd(Query<T, F> var1, Pageable var2);

    private Pageable getPageable(Query<T, F> q) {
        Pair<Integer, Integer> pageSizeAndNumber = PageableDataProvider.limitAndOffsetToPageSizeAndNumber(q.getOffset(), q.getLimit());
        return PageRequest.of((int)((Integer)pageSizeAndNumber.getSecond()), (int)((Integer)pageSizeAndNumber.getFirst()), (Sort)this.createSpringSort(q));
    }

    private Sort createSpringSort(Query<T, F> q) {
        List sortOrders = q.getSortOrders().isEmpty() ? this.getDefaultSortOrders() : q.getSortOrders();
        List orders = sortOrders.stream().map(PageableDataProvider::queryOrderToSpringOrder).collect(Collectors.toList());
        if (orders.isEmpty()) {
            return null;
        }
        return Sort.by(orders);
    }

    protected abstract List<QuerySortOrder> getDefaultSortOrders();

    private static Sort.Order queryOrderToSpringOrder(QuerySortOrder queryOrder) {
        return new Sort.Order(queryOrder.getDirection() == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC, queryOrder.getSorted());
    }

    public static Pair<Integer, Integer> limitAndOffsetToPageSizeAndNumber(int offset, int limit) {
        int minPageSize = limit;
        int lastIndex = offset + limit - 1;
        int maxPageSize = lastIndex + 1;
        for (double pageSize = (double)minPageSize; pageSize <= (double)maxPageSize; pageSize += 1.0) {
            int startPage = (int)((double)offset / pageSize);
            int endPage = (int)((double)lastIndex / pageSize);
            if (startPage != endPage) continue;
            return Pair.of((Object)((int)pageSize), (Object)startPage);
        }
        return Pair.of((Object)maxPageSize, (Object)0);
    }

    private Stream<T> fromPageable(Page<T> result, Pageable pageable, Query<T, ?> query) {
        List items = result.getContent();
        int firstRequested = query.getOffset();
        int nrRequested = query.getLimit();
        int firstReturned = (int)pageable.getOffset();
        int firstReal = firstRequested - firstReturned;
        int afterLastReal = firstReal + nrRequested;
        if (afterLastReal > items.size()) {
            afterLastReal = items.size();
        }
        return items.subList(firstReal, afterLastReal).stream();
    }
}

