/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events;

import java.io.Serializable;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.EventScope;

public class Event<T>
implements Serializable {
    private static final long serialVersionUID = 4818820872533486223L;
    private final EventBus eventBus;
    private final Object source;
    private final String topic;
    private final long timestamp;
    private final T payload;

    public Event(EventBus eventBus, Object source, T payload) {
        this(eventBus, source, payload, "");
    }

    public Event(EventBus eventBus, Object source, T payload, String topic) {
        this.eventBus = eventBus;
        this.source = source;
        this.payload = payload;
        this.topic = topic != null ? topic : "";
        this.timestamp = System.currentTimeMillis();
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public EventScope getScope() {
        return this.eventBus.getScope();
    }

    public Object getSource() {
        return this.source;
    }

    public String getTopic() {
        return this.topic;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T getPayload() {
        return this.payload;
    }

    public String toString() {
        return String.format("%s[scope=%s, eventBus=%s, ts=%d, source=[%s], payload=[%s]]", new Object[]{this.getClass().getSimpleName(), this.getScope(), this.getEventBus(), this.getTimestamp(), this.getSource(), this.getPayload()});
    }
}

