/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.spring.events.Event;

class ListenerCollection
implements Serializable {
    private static final long serialVersionUID = -6237902400879667320L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<Listener> listeners = new HashSet<Listener>();
    private final Set<Listener> weakListeners = Collections.newSetFromMap(new WeakHashMap());

    ListenerCollection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Listener listener) {
        this.logger.trace("Adding listener [{}]", (Object)listener);
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWithWeakReference(Listener listener) {
        this.logger.trace("Adding listener [{}] using a weak reference", (Object)listener);
        Set<Listener> set = this.weakListeners;
        synchronized (set) {
            this.weakListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Listener listener) {
        this.logger.trace("Removing listener [{}]", (Object)listener);
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
        set = this.weakListeners;
        synchronized (set) {
            this.weakListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ListenerFilter filter) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.removeFilteredListenersFromSet(filter, this.listeners);
        }
        set = this.weakListeners;
        synchronized (set) {
            this.removeFilteredListenersFromSet(filter, this.weakListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
        set = this.weakListeners;
        synchronized (set) {
            this.weakListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Event<?> event) {
        HashSet<Listener> interestedListeners = new HashSet<Listener>();
        Object object = this.listeners;
        synchronized (object) {
            this.addSupportedListenersToSet(this.listeners, interestedListeners, event);
        }
        object = this.weakListeners;
        synchronized (object) {
            this.addSupportedListenersToSet(this.weakListeners, interestedListeners, event);
        }
        if (interestedListeners.isEmpty()) {
            this.logger.debug("No listeners supported event [{}]", event);
        } else {
            for (Listener listener : interestedListeners) {
                this.logger.trace("Publishing event [{}] to listener [{}]", event, (Object)listener);
                listener.publish(event);
            }
        }
    }

    private <T> void addSupportedListenersToSet(Set<Listener> candidateListeners, Set<Listener> selectedListeners, Event<T> event) {
        for (Listener candidateListener : candidateListeners) {
            if (!candidateListener.supports(event)) continue;
            this.logger.trace("Listener [{}] supports event [{}]", (Object)candidateListener, event);
            selectedListeners.add(candidateListener);
        }
    }

    private void removeFilteredListenersFromSet(ListenerFilter filter, Set<Listener> listenerSet) {
        Iterator<Listener> it = listenerSet.iterator();
        while (it.hasNext()) {
            Listener listener = it.next();
            if (!filter.passes(listener)) continue;
            this.logger.trace("Removing listener [{}]", (Object)listener);
            it.remove();
        }
    }

    public static interface ListenerFilter {
        public boolean passes(Listener var1);
    }

    public static interface Listener
    extends Serializable {
        public boolean supports(Event<?> var1);

        public void publish(Event<?> var1);
    }
}

