/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.vaadin.spring.events.Event;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.EventBusListenerMethodFilter;
import org.vaadin.spring.events.EventScope;
import org.vaadin.spring.events.TopicFilter;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.events.annotation.EventBusListenerTopic;
import org.vaadin.spring.events.internal.AbstractListenerWrapper;

class MethodListenerWrapper
extends AbstractListenerWrapper {
    private static final long serialVersionUID = -3624543380547361337L;
    private final Class<?> payloadType;
    private final boolean payloadMethod;
    private transient Method listenerMethod;
    private final String topic;

    public MethodListenerWrapper(EventBus owningEventBus, Object listenerTarget, String topic, boolean includingPropagatingEvents, Method listenerMethod) {
        super(owningEventBus, listenerTarget, topic, includingPropagatingEvents);
        this.topic = topic;
        if (listenerMethod.getParameterTypes()[0] == Event.class) {
            ParameterizedType type = (ParameterizedType)listenerMethod.getGenericParameterTypes()[0];
            this.payloadType = (Class)type.getActualTypeArguments()[0];
            this.payloadMethod = false;
        } else {
            this.payloadType = listenerMethod.getParameterTypes()[0];
            this.payloadMethod = true;
        }
        this.listenerMethod = listenerMethod;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    @Override
    public Class<?> getPayloadType() {
        return this.payloadType;
    }

    @Override
    public void publish(Event<?> event) {
        this.listenerMethod.setAccessible(true);
        try {
            if (this.payloadMethod) {
                this.listenerMethod.invoke(this.getListenerTarget(), event.getPayload());
            } else {
                this.listenerMethod.invoke(this.getListenerTarget(), event);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access listener method " + this.listenerMethod.getName());
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new RuntimeException("A checked exception occurred while invoking listener method " + this.listenerMethod.getName(), targetException);
        }
    }

    @Override
    public boolean supports(Event<?> event) {
        boolean supports = super.supports(event);
        try {
            if (this.listenerMethod.isAnnotationPresent(EventBusListenerMethod.class)) {
                boolean bl = supports = supports && this.isInterestedListenerMethod(event);
            }
            if (this.topic != null) {
                return supports;
            }
            if (this.listenerMethod.isAnnotationPresent(EventBusListenerTopic.class) && supports) {
                supports = this.isInTopic(event);
            } else if (!event.getTopic().isEmpty()) {
                supports = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("A checked exception occurred while invoking listener method " + this.listenerMethod.getName(), e);
        }
        return supports;
    }

    private boolean isInterestedListenerMethod(Event<?> event) throws InstantiationException, IllegalAccessException {
        EventBusListenerMethod annotation = this.listenerMethod.getAnnotation(EventBusListenerMethod.class);
        EventBusListenerMethodFilter filter = annotation.filter().newInstance();
        EventScope scope = annotation.scope();
        if (scope.equals((Object)EventScope.UNDEFINED)) {
            scope = event.getScope();
        }
        return filter.filter(event) && event.getScope().equals((Object)scope) && this.isFromSource(event, annotation.source());
    }

    private boolean isFromSource(Event<?> event, Class<?>[] sources) {
        if (sources.length == 0) {
            return true;
        }
        boolean result = false;
        for (int i = 0; i < sources.length && !result; result |= sources[i].isAssignableFrom(event.getSource().getClass()), ++i) {
        }
        return result;
    }

    private boolean isInTopic(Event<?> event) throws InstantiationException, IllegalAccessException {
        EventBusListenerTopic annotation = this.listenerMethod.getAnnotation(EventBusListenerTopic.class);
        TopicFilter filter = annotation.filter().newInstance();
        return filter.validTopic(event.getTopic(), annotation.topic());
    }
}

