/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.internal;

import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.vaadin.spring.events.Event;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.EventBusListener;
import org.vaadin.spring.events.EventScope;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.events.internal.AbstractListenerWrapper;
import org.vaadin.spring.events.internal.EventBusListenerWrapper;
import org.vaadin.spring.events.internal.ListenerCollection;
import org.vaadin.spring.events.internal.MethodListenerWrapper;
import org.vaadin.spring.util.ClassUtils;

public abstract class ScopedEventBus
implements EventBus,
Serializable {
    private static final long serialVersionUID = 1637290543180920954L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventScope eventScope;
    private final ListenerCollection listeners = new ListenerCollection();
    private EventBus parentEventBus;
    private EventBusListener<Object> parentListener = new EventBusListener<Object>(){
        private static final long serialVersionUID = -8276470908536582989L;

        @Override
        public void onEvent(Event<Object> event) {
            ScopedEventBus.this.logger.debug("Propagating event [{}] from parent event bus [{}] to event bus [{}]", new Object[]{event, ScopedEventBus.this.parentEventBus, ScopedEventBus.this});
            ScopedEventBus.this.listeners.publish(event);
        }
    };

    public ScopedEventBus(EventScope scope) {
        this(scope, null);
    }

    public ScopedEventBus(EventScope scope, EventBus parentEventBus) {
        this.eventScope = scope;
        this.parentEventBus = parentEventBus;
        if (parentEventBus != null) {
            if (AopUtils.isJdkDynamicProxy((Object)parentEventBus)) {
                this.logger.debug("Parent event bus [{}] is proxied, trying to get the real EventBus instance", (Object)parentEventBus);
                try {
                    this.parentEventBus = (EventBus)((Advised)parentEventBus).getTargetSource().getTarget();
                }
                catch (Exception e) {
                    this.logger.error("Could not get target EventBus from proxy", (Throwable)e);
                    throw new RuntimeException("Could not get parent event bus", e);
                }
            }
            this.logger.debug("Using parent event bus [{}]", (Object)this.parentEventBus);
            this.parentEventBus.subscribe(this.parentListener);
        }
    }

    @PreDestroy
    void destroy() {
        this.logger.trace("Destroying event bus [{}] and removing all listeners", (Object)this);
        this.listeners.clear();
        if (this.parentEventBus != null) {
            this.parentEventBus.unsubscribe(this.parentListener);
        }
    }

    @Override
    public EventScope getScope() {
        return this.eventScope;
    }

    @Override
    public <T> void publish(Object sender, T payload) {
        this.publish("", sender, payload);
    }

    @Override
    public <T> void publish(String topic, Object sender, T payload) {
        this.logger.debug("Publishing payload [{}] from sender [{}] on event bus [{}] in topic  [{}]", new Object[]{payload, sender, this, topic});
        this.listeners.publish(new Event<T>(this, sender, payload, topic));
    }

    @Override
    public <T> void publish(EventScope scope, Object sender, T payload) throws UnsupportedOperationException {
        this.publish(scope, "", sender, payload);
    }

    @Override
    public <T> void publish(EventScope scope, String topic, Object sender, T payload) throws UnsupportedOperationException {
        this.logger.debug("Trying to publish payload [{}] from sender [{}] using scope [{}] on event bus [{}] in topic [{}]", new Object[]{payload, sender, scope, this, topic});
        if (this.eventScope.equals((Object)scope)) {
            this.publish(topic, sender, payload);
        } else if (this.parentEventBus != null) {
            this.parentEventBus.publish(scope, topic, sender, payload);
        } else {
            this.logger.warn("Could not publish payload with scope [{}] on event bus [{}]", (Object)scope, (Object)this);
            throw new UnsupportedOperationException("Could not publish event with scope " + scope);
        }
    }

    @Override
    public <T> void subscribe(EventBusListener<T> listener) {
        this.subscribe(listener, true);
    }

    @Override
    public <T> void subscribeWithWeakReference(EventBusListener<T> listener) {
        this.subscribeWithWeakReference(listener, true);
    }

    @Override
    public <T> void subscribe(EventBusListener<T> listener, String topic) {
        this.logger.trace("Subscribing listener [{}] to event bus [{}]", listener, (Object)this);
        this.listeners.add(new EventBusListenerWrapper((EventBus)this, listener, topic, true));
    }

    @Override
    public <T> void subscribe(EventBusListener<T> listener, boolean includingPropagatingEvents) {
        this.logger.trace("Subscribing listener [{}] to event bus [{}], includingPropagatingEvents = {}", new Object[]{listener, this, includingPropagatingEvents});
        this.listeners.add(new EventBusListenerWrapper((EventBus)this, listener, null, includingPropagatingEvents));
    }

    @Override
    public <T> void subscribeWithWeakReference(EventBusListener<T> listener, String topic) {
        this.logger.trace("Subscribing listener [{}] to event bus [{}] with weak reference", listener, (Object)this);
        this.listeners.addWithWeakReference(new EventBusListenerWrapper((EventBus)this, listener, topic, true));
    }

    @Override
    public <T> void subscribeWithWeakReference(EventBusListener<T> listener, boolean includingPropagatingEvents) {
        this.logger.trace("Subscribing listener [{}] to event bus [{}] with weak reference, includingPropagatingEvents = {}", new Object[]{listener, this, includingPropagatingEvents});
        this.listeners.addWithWeakReference(new EventBusListenerWrapper((EventBus)this, listener, null, includingPropagatingEvents));
    }

    @Override
    public void subscribe(Object listener) {
        this.subscribe(listener, true);
    }

    @Override
    public void subscribe(Object listener, String topic) {
        this.subscribe(listener, topic, true, false);
    }

    @Override
    public void subscribeWithWeakReference(Object listener, String topic) {
        this.subscribe(listener, topic, true, false);
    }

    @Override
    public void subscribeWithWeakReference(Object listener) {
        this.subscribeWithWeakReference(listener, true);
    }

    @Override
    public void subscribe(Object listener, boolean includingPropagatingEvents) {
        this.subscribe(listener, null, includingPropagatingEvents, false);
    }

    @Override
    public void subscribeWithWeakReference(Object listener, boolean includingPropagatingEvents) {
        this.subscribe(listener, null, includingPropagatingEvents, true);
    }

    private void subscribe(final Object listener, final String topic, final boolean includingPropagatingEvents, final boolean weakReference) {
        this.logger.trace("Subscribing listener [{}] to event bus [{}], includingPropagatingEvents = {}, weakReference = {}", new Object[]{listener, this, includingPropagatingEvents, weakReference});
        final int[] foundMethods = new int[1];
        ClassUtils.visitClassHierarchy((ClassUtils.ClassVisitor)new ClassUtils.ClassVisitor(){

            public void visit(Class<?> clazz) {
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!m.isAnnotationPresent(EventBusListenerMethod.class)) continue;
                    if (m.getParameterTypes().length == 1) {
                        ScopedEventBus.this.logger.trace("Found listener method [{}] in listener [{}]", (Object)m.getName(), listener);
                        MethodListenerWrapper l = new MethodListenerWrapper(ScopedEventBus.this, listener, topic, includingPropagatingEvents, m);
                        if (weakReference) {
                            ScopedEventBus.this.listeners.addWithWeakReference(l);
                        } else {
                            ScopedEventBus.this.listeners.add(l);
                        }
                        foundMethods[0] = foundMethods[0] + 1;
                        continue;
                    }
                    throw new IllegalArgumentException("Listener method " + m.getName() + " does not have the required signature");
                }
            }
        }, listener.getClass());
        if (foundMethods[0] == 0) {
            this.logger.warn("Listener [{}] did not contain a single listener method!", listener);
        }
    }

    @Override
    public <T> void unsubscribe(EventBusListener<T> listener) {
        this.unsubscribe((Object)listener);
    }

    @Override
    public void unsubscribe(final Object listener) {
        this.logger.trace("Unsubscribing listener [{}] from event bus [{}]", listener, (Object)this);
        this.listeners.removeAll(new ListenerCollection.ListenerFilter(){

            @Override
            public boolean passes(ListenerCollection.Listener l) {
                return l instanceof AbstractListenerWrapper && ((AbstractListenerWrapper)l).getListenerTarget() == listener;
            }
        });
    }

    protected EventBus getParentEventBus() {
        return this.parentEventBus;
    }

    public String toString() {
        return String.format("%s[id=%x, eventScope=%s, parentEventBus=%s]", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this), this.eventScope, this.parentEventBus});
    }

    public static class DefualtViewEventBus
    extends ScopedEventBus
    implements EventBus.ViewEventBus {
        public DefualtViewEventBus(EventBus.UIEventBus parentEventBus) {
            super(EventScope.VIEW, parentEventBus);
        }
    }

    public static class DefaultUIEventBus
    extends ScopedEventBus
    implements EventBus.UIEventBus {
        public DefaultUIEventBus(EventBus.SessionEventBus parentEventBus) {
            super(EventScope.UI, parentEventBus);
        }
    }

    public static class DefaultSessionEventBus
    extends ScopedEventBus
    implements EventBus.SessionEventBus {
        public DefaultSessionEventBus(EventBus.ApplicationEventBus parentEventBus) {
            super(EventScope.SESSION, parentEventBus);
        }
    }

    public static class DefaultApplicationEventBus
    extends ScopedEventBus
    implements EventBus.ApplicationEventBus {
        public DefaultApplicationEventBus() {
            super(EventScope.APPLICATION);
        }
    }
}

