/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.boot.internal;

import com.vaadin.navigator.PushStateNavigation;
import com.vaadin.server.VaadinServlet;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.boot.internal.VaadinServletConfigurationProperties;
import com.vaadin.spring.server.SpringVaadinServlet;
import jakarta.servlet.Servlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.ServletForwardingController;

@Configuration
@EnableConfigurationProperties(value={VaadinServletConfigurationProperties.class})
public class VaadinServletConfiguration
implements InitializingBean {
    private static final String PATH_WILDCARD_ALL = "/**";
    private static final String PATH_WILDCARD_SINGLE = "/*";
    private static final String DEFAULT_SERVLET_URL_BASE = "/vaadinServlet";
    public static final String DEFAULT_SERVLET_URL_MAPPING = "/vaadinServlet/*";
    public static final String STATIC_RESOURCES_URL_MAPPING = "/VAADIN/*";
    private static Logger logger = LoggerFactory.getLogger(VaadinServletConfiguration.class);
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected VaadinServletConfigurationProperties configurationProperties;

    @Bean
    public SimpleUrlHandlerMapping vaadinUiForwardingHandlerMapping() {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setOrder(-2147483647);
        HashMap<Object, Controller> urlMappings = new HashMap<Object, Controller>();
        if (this.isMappedToRoot()) {
            for (String path : this.getUIPaths()) {
                urlMappings.put("/" + path, this.vaadinUiForwardingController());
                if (path.length() <= 0) continue;
                urlMappings.put(this.getAlternativePath(path), this.vaadinUiForwardingController());
            }
            this.getLogger().info("Forwarding @SpringUI URLs from {}", urlMappings);
        }
        mapping.setUrlMap(urlMappings);
        return mapping;
    }

    protected List<String> getUIPaths() {
        String[] uiBeanNames;
        ArrayList<String> uiMappings = new ArrayList<String>();
        logger.info("Checking the application context for Vaadin UI mappings");
        for (String uiBeanName : uiBeanNames = this.applicationContext.getBeanNamesForAnnotation(SpringUI.class)) {
            boolean hasPushStateNavigation;
            SpringUI annotation = (SpringUI)this.applicationContext.findAnnotationOnBean(uiBeanName, SpringUI.class);
            String path = this.applicationContext.getEnvironment().resolvePlaceholders(annotation != null ? annotation.path() : "").replaceFirst("^/", "");
            boolean bl = hasPushStateNavigation = this.applicationContext.findAnnotationOnBean(uiBeanName, PushStateNavigation.class) != null;
            if (hasPushStateNavigation) {
                path = this.getWildcardedPath(path);
            }
            uiMappings.add(path);
        }
        return uiMappings;
    }

    private String getAlternativePath(String path) {
        StringBuilder builder = new StringBuilder("/");
        if (path.endsWith(PATH_WILDCARD_SINGLE)) {
            builder.append(path.substring(0, path.length() - PATH_WILDCARD_SINGLE.length()));
        } else if (path.endsWith(PATH_WILDCARD_ALL)) {
            builder.append(path.substring(0, path.length() - PATH_WILDCARD_ALL.length()));
        } else {
            builder.append(path + "/");
        }
        return builder.toString();
    }

    private String getWildcardedPath(String path) {
        if (((String)path).endsWith(PATH_WILDCARD_SINGLE)) {
            path = (String)path + "*";
        } else if (!((String)path).endsWith(PATH_WILDCARD_ALL)) {
            path = (String)path + PATH_WILDCARD_ALL;
        }
        assert (((String)path).endsWith(PATH_WILDCARD_ALL)) : "PushStateNavigation UI Path should end with '/**'";
        return path;
    }

    protected Logger getLogger() {
        return logger;
    }

    @Bean
    public Controller vaadinUiForwardingController() {
        VaadinServlet servlet = this.vaadinServlet();
        this.getLogger().info("Registering Vaadin servlet of type [{}]", (Object)servlet.getClass().getCanonicalName());
        ServletForwardingController controller = new ServletForwardingController();
        controller.setServletName(this.vaadinServletRegistration().getServletName());
        return controller;
    }

    protected boolean isMappedToRoot() {
        String prefix = this.configurationProperties.getUrlMapping();
        if (prefix == null) {
            return true;
        }
        prefix = prefix.trim().replaceAll("(/\\**)?$", "");
        return "".equals(prefix);
    }

    protected String[] getUrlMappings() {
        if (this.isMappedToRoot()) {
            return new String[]{DEFAULT_SERVLET_URL_MAPPING, STATIC_RESOURCES_URL_MAPPING};
        }
        String mapping = this.configurationProperties.getUrlMapping();
        String baseMapping = mapping.trim().replaceAll("(/\\**)?$", "");
        return new String[]{baseMapping, baseMapping + PATH_WILDCARD_SINGLE, STATIC_RESOURCES_URL_MAPPING};
    }

    @Bean
    protected ServletRegistrationBean<?> vaadinServletRegistration() {
        return this.createServletRegistrationBean();
    }

    public void afterPropertiesSet() throws Exception {
        this.getLogger().debug("{} initialized", (Object)this.getClass().getName());
    }

    @Bean
    @ConditionalOnMissingBean
    public VaadinServlet vaadinServlet() {
        return new SpringVaadinServlet();
    }

    protected ServletRegistrationBean<?> createServletRegistrationBean() {
        this.getLogger().info("Registering Vaadin servlet");
        String[] urlMappings = this.getUrlMappings();
        this.getLogger().info("Servlet will be mapped to URLs {}", (Object)urlMappings);
        VaadinServlet servlet = this.vaadinServlet();
        if (servlet instanceof SpringVaadinServlet && this.isMappedToRoot()) {
            SpringVaadinServlet vaadinServlet = (SpringVaadinServlet)servlet;
            vaadinServlet.setServiceUrlPath(DEFAULT_SERVLET_URL_BASE);
        }
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)servlet, urlMappings);
        this.addInitParameters(registrationBean);
        return registrationBean;
    }

    protected void addInitParameters(ServletRegistrationBean<?> servletRegistrationBean) {
        this.getLogger().info("Setting servlet init parameters");
        this.addInitParameter(servletRegistrationBean, "productionMode", String.valueOf(this.configurationProperties.isProductionMode()));
        this.addInitParameter(servletRegistrationBean, "resourceCacheTime", String.valueOf(this.configurationProperties.getResourceCacheTime()));
        this.addInitParameter(servletRegistrationBean, "heartbeatInterval", String.valueOf(this.configurationProperties.getHeartbeatInterval()));
        this.addInitParameter(servletRegistrationBean, "closeIdleSessions", String.valueOf(this.configurationProperties.isCloseIdleSessions()));
        this.addInitParameter(servletRegistrationBean, "Resources", this.configurationProperties.getResources());
    }

    private void addInitParameter(ServletRegistrationBean<?> servletRegistrationBean, String paramName, String propertyValue) {
        if (propertyValue != null) {
            this.getLogger().info("Set servlet init parameter [{}] = [{}]", (Object)paramName, (Object)propertyValue);
            servletRegistrationBean.addInitParameter(paramName, propertyValue);
        }
    }
}

