/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.servlet;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceDestroyListener;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.SystemMessagesProvider;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.spring.server.SpringVaadinServlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.vaadin.spring.servlet.CustomInitParameterProvider;
import org.vaadin.spring.servlet.Vaadin4SpringServletService;

public class Vaadin4SpringServlet
extends SpringVaadinServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Vaadin4SpringServlet.class);

    public Vaadin4SpringServlet() {
        LOGGER.info("Using custom Vaadin4Spring servlet");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init((ServletConfig)new ServletConfigWrapper(servletConfig));
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        Vaadin4SpringServletService service = new Vaadin4SpringServletService((VaadinServlet)this, deploymentConfiguration, this.getServiceUrlPath());
        service.init();
        return service;
    }

    protected void servletInitialized() throws ServletException {
        super.servletInitialized();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        try {
            SystemMessagesProvider systemMessagesProvider = (SystemMessagesProvider)applicationContext.getBean(SystemMessagesProvider.class);
            LOGGER.info("Using custom SystemMessagesProvider {}", (Object)systemMessagesProvider);
            this.getService().setSystemMessagesProvider(systemMessagesProvider);
        }
        catch (BeansException ex) {
            LOGGER.info("Could not find a SystemMessagesProvider in the application context, using default");
        }
        for (SessionInitListener sessionInitListener : applicationContext.getBeansOfType(SessionInitListener.class).values()) {
            LOGGER.info("Adding SessionInitListener {}", (Object)sessionInitListener);
            this.getService().addSessionInitListener(sessionInitListener);
        }
        for (SessionDestroyListener sessionDestroyListener : applicationContext.getBeansOfType(SessionDestroyListener.class).values()) {
            LOGGER.info("Adding SessionDestroyListener {}", (Object)sessionDestroyListener);
            this.getService().addSessionDestroyListener(sessionDestroyListener);
        }
        for (ServiceDestroyListener serviceDestroyListener : applicationContext.getBeansOfType(ServiceDestroyListener.class).values()) {
            LOGGER.info("Adding ServiceDestroyListener {}", (Object)serviceDestroyListener);
            this.getService().addServiceDestroyListener(serviceDestroyListener);
        }
        LOGGER.info("Custom Vaadin4Spring servlet initialization completed");
    }

    private static class ServletConfigWrapper
    implements ServletConfig {
        private final ServletConfig delegate;
        private final Set<CustomInitParameterProvider> customInitParameterProviders;

        private ServletConfigWrapper(ServletConfig delegate) {
            this.delegate = delegate;
            WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)delegate.getServletContext());
            this.customInitParameterProviders = new HashSet(applicationContext.getBeansOfType(CustomInitParameterProvider.class).values());
            LOGGER.info("Found {} custom init parameter provider(s)", (Object)this.customInitParameterProviders.size());
        }

        public String getServletName() {
            return this.delegate.getServletName();
        }

        public ServletContext getServletContext() {
            return this.delegate.getServletContext();
        }

        public String getInitParameter(String name) {
            for (CustomInitParameterProvider provider : this.customInitParameterProviders) {
                if (!provider.containsInitParameter(name)) continue;
                LOGGER.trace("Found custom init parameter [{}] in provider [{}]", (Object)name, (Object)provider);
                return provider.getInitParameter(name);
            }
            LOGGER.trace("No custom init parameter named [{}] found, delegating to original ServletConfig", (Object)name);
            return this.delegate.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            HashSet<String> initParameterNames = new HashSet<String>();
            Enumeration delegateInitParameterNames = this.delegate.getInitParameterNames();
            while (delegateInitParameterNames.hasMoreElements()) {
                initParameterNames.add((String)delegateInitParameterNames.nextElement());
            }
            for (CustomInitParameterProvider provider : this.customInitParameterProviders) {
                initParameterNames.addAll(provider.getInitParameterNames());
            }
            LOGGER.trace("Init parameter names are {}", initParameterNames);
            return new Vector(initParameterNames).elements();
        }
    }
}

