/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.servlet;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.server.SpringVaadinServletService;
import jakarta.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.vaadin.spring.request.VaadinRequestEndListener;
import org.vaadin.spring.request.VaadinRequestStartListener;

public class Vaadin4SpringServletService
extends SpringVaadinServletService {
    private static final Logger logger = LoggerFactory.getLogger(Vaadin4SpringServletService.class);
    private final WebApplicationContext applicationContext;

    public Vaadin4SpringServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration, String serviceUrl) throws ServiceException {
        super(servlet, deploymentConfiguration, serviceUrl);
        logger.info("Using custom Vaadin4Spring servlet service");
        this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servlet.getServletContext());
    }

    public void requestStart(VaadinRequest request, VaadinResponse response) {
        super.requestStart(request, response);
        logger.trace("Invoking VaadinRequestStartListeners");
        for (VaadinRequestStartListener listener : this.applicationContext.getBeansOfType(VaadinRequestStartListener.class).values()) {
            try {
                listener.onRequestStart(request, response);
            }
            catch (Exception ex) {
                logger.error("VaadinRequestStartListener threw an exception, ignoring", (Throwable)ex);
            }
        }
        logger.trace("Finished invoking VaadinRequestStartListeners");
    }

    public void requestEnd(VaadinRequest request, VaadinResponse response, VaadinSession session) {
        logger.trace("Invoking VaadinRequestEndListeners");
        for (VaadinRequestEndListener listener : this.applicationContext.getBeansOfType(VaadinRequestEndListener.class).values()) {
            try {
                listener.onRequestEnd(request, response, session);
            }
            catch (Exception ex) {
                logger.error("VaadinRequestEndListener threw an exception, ignoring", (Throwable)ex);
            }
        }
        logger.trace("Finished invoking VaadinRequestEndListener");
        super.requestEnd(request, response, session);
    }
}

