/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.access;

import com.vaadin.navigator.View;
import com.vaadin.spring.access.ViewAccessControl;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.spring.server.SpringVaadinServletService;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@SpringComponent
public class SecuredViewAccessControl
implements ViewAccessControl,
Serializable {
    @Autowired
    private transient ApplicationContext applicationContext;

    protected boolean isAccessGranted(String[] securityConfigAttributes) {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            return false;
        }
        Set authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        return Stream.of(securityConfigAttributes).anyMatch(authorities::contains);
    }

    public boolean isAccessGranted(UI ui, String beanName) {
        Secured viewSecured = (Secured)this.getApplicationContext(ui).findAnnotationOnBean(beanName, Secured.class);
        return this.isAccessGranted(viewSecured);
    }

    public boolean isAccessGranted(Class<? extends View> viewClass) {
        Secured viewSecured = null;
        if (viewClass != null) {
            viewSecured = (Secured)AnnotationUtils.findAnnotation(viewClass, Secured.class);
        }
        return this.isAccessGranted(viewSecured);
    }

    protected boolean isAccessGranted(Secured viewSecured) {
        if (viewSecured == null) {
            return true;
        }
        return this.isAccessGranted(viewSecured.value());
    }

    private ApplicationContext getApplicationContext(UI ui) {
        if (this.applicationContext == null) {
            this.applicationContext = ((SpringVaadinServletService)ui.getSession().getService()).getWebApplicationContext();
        }
        return this.applicationContext;
    }
}

