/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import com.vaadin.flow.server.startup.AnnotationValidator;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.LookupServletContainerInitializer;
import com.vaadin.flow.server.startup.ServletDeployer;
import com.vaadin.flow.server.startup.ServletVerifier;
import com.vaadin.flow.server.startup.VaadinAppShellInitializer;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import com.vaadin.flow.server.startup.WebComponentConfigurationRegistryInitializer;
import com.vaadin.flow.server.startup.WebComponentExporterAwareValidator;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.spring.PrefixTree;
import com.vaadin.flow.spring.SpringLookupInitializer;
import com.vaadin.flow.spring.VaadinScanPackagesRegistrar;
import com.vaadin.flow.theme.Theme;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;

public class VaadinServletContextInitializer
implements ServletContextInitializer {
    private ApplicationContext appContext;
    private ResourceLoader customLoader;
    private static final List<String> DEFAULT_SCAN_NEVER = Stream.of("antlr", "cglib", "ch/quos/logback", "commons-codec", "commons-fileupload", "commons-io", "commons-logging", "com/fasterxml", "com/google", "com/h2database", "com/helger", "com/vaadin/external/atmosphere", "com/vaadin/webjar", "junit", "net/bytebuddy", "org/apache", "org/aspectj", "org/bouncycastle", "org/dom4j", "org/easymock", "org/eclipse/persistence", "org/hamcrest", "org/hibernate", "org/javassist", "org/jboss", "org/jsoup", "org/seleniumhq", "org/slf4j", "org/atmosphere", "org/springframework", "org/webjars/bowergithub", "org/yaml", "java/", "javax/", "javafx/", "com/sun/", "oracle/deploy", "oracle/javafx", "oracle/jrockit", "oracle/jvm", "oracle/net", "oracle/nio", "oracle/tools", "oracle/util", "oracle/webservices", "oracle/xmlns", "com/intellij/", "org/jetbrains").collect(Collectors.toList());
    private static final List<String> DEFAULT_SCAN_ONLY = Stream.of(Component.class.getPackage().getName(), Theme.class.getPackage().getName(), "com.vaadin.shrinkwrap").collect(Collectors.toList());
    private final List<String> customScanOnly;

    public VaadinServletContextInitializer(ApplicationContext context) {
        this.appContext = context;
        String neverScanProperty = this.appContext.getEnvironment().getProperty("vaadin.blacklisted-packages");
        List<String> neverScan = neverScanProperty == null ? Collections.emptyList() : Arrays.stream(neverScanProperty.split(",")).map(String::trim).collect(Collectors.toList());
        String onlyScanProperty = this.appContext.getEnvironment().getProperty("vaadin.whitelisted-packages");
        if (onlyScanProperty == null) {
            this.customScanOnly = Collections.emptyList();
            this.customLoader = new CustomResourceLoader((ResourceLoader)this.appContext, neverScan);
        } else {
            this.customScanOnly = Arrays.stream(onlyScanProperty.split(",")).map(onlyPackage -> onlyPackage.replace('/', '.').trim()).collect(Collectors.toList());
            this.customLoader = this.appContext;
        }
        if (!this.customScanOnly.isEmpty() && !neverScan.isEmpty()) {
            VaadinServletContextInitializer.getLogger().warn("vaadin.blacklisted-packages is ignored because both vaadin.whitelisted-packages and vaadin.blacklisted-packages have been set.");
        }
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        ServletVerifier.verifyServletVersion();
        VaadinServletContext vaadinContext = new VaadinServletContext(servletContext);
        servletContext.addListener((EventListener)((Object)this.createCompositeListener(vaadinContext)));
    }

    private CompositeServletContextListener createCompositeListener(VaadinServletContext context) {
        CompositeServletContextListener compositeListener = new CompositeServletContextListener();
        compositeListener.addListener(new LookupInitializerListener());
        compositeListener.addListener(new VaadinAppShellContextListener());
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)context);
        if (registry.getRegisteredRoutes().isEmpty()) {
            compositeListener.addListener(new RouteServletContextListener());
        }
        compositeListener.addListener(new ErrorParameterServletContextListener());
        compositeListener.addListener(new AnnotationValidatorServletContextListener());
        compositeListener.addListener(new DevModeServletContextListener());
        if (!WebComponentConfigurationRegistry.getInstance((VaadinContext)context).hasConfigurations()) {
            compositeListener.addListener(new WebComponentServletContextListener());
        }
        return compositeListener;
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, Class<? extends Annotation> ... annotations) {
        return this.findByAnnotation(packages, (ResourceLoader)this.appContext, annotations);
    }

    private Stream<Class<?>> findByAnnotation(Collection<String> packages, ResourceLoader loader, Class<? extends Annotation> ... annotations) {
        return this.findByAnnotationOrSuperType(packages, loader, Arrays.asList(annotations), Collections.emptySet());
    }

    private Stream<Class<?>> findBySuperType(Collection<String> packages, Class<?> type) {
        return this.findBySuperType(packages, (ResourceLoader)this.appContext, type);
    }

    private Stream<Class<?>> findBySuperType(Collection<String> packages, ResourceLoader loader, Class<?> type) {
        return this.findByAnnotationOrSuperType(packages, loader, Collections.emptySet(), Collections.singleton(type));
    }

    private Stream<Class<?>> findByAnnotationOrSuperType(Collection<String> packages, ResourceLoader loader, Collection<Class<? extends Annotation>> annotations, Collection<Class<?>> types) {
        ClassPathScanner scanner = new ClassPathScanner(this.appContext.getEnvironment(), loader, annotations, types);
        return packages.stream().map(arg_0 -> ((ClassPathScanner)scanner).findCandidateComponents(arg_0)).flatMap(Collection::stream).map(this::getBeanClass);
    }

    private Class<?> getBeanClass(BeanDefinition beanDefinition) {
        Class beanClass;
        AbstractBeanDefinition definition = (AbstractBeanDefinition)beanDefinition;
        if (definition.hasBeanClass()) {
            beanClass = definition.getBeanClass();
        } else {
            try {
                beanClass = definition.resolveBeanClass(this.appContext.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return beanClass;
    }

    private Collection<String> getRoutePackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getVerifiableAnnotationPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getWebComponentPackages() {
        return this.getDefaultPackages();
    }

    private Collection<String> getErrorParameterPackages() {
        return Stream.concat(Stream.of(HasErrorParameter.class.getPackage().getName()), this.getDefaultPackages().stream()).collect(Collectors.toSet());
    }

    private List<String> getDefaultPackages() {
        List packagesList = Collections.emptyList();
        if (this.appContext.getBeanNamesForType(VaadinScanPackagesRegistrar.VaadinScanPackages.class).length > 0) {
            VaadinScanPackagesRegistrar.VaadinScanPackages packages = (VaadinScanPackagesRegistrar.VaadinScanPackages)this.appContext.getBean(VaadinScanPackagesRegistrar.VaadinScanPackages.class);
            packagesList = packages.getScanPackages();
        }
        if (!packagesList.isEmpty()) {
            VaadinServletContextInitializer.getLogger().trace("Using explicitly configured packages for scan Vaadin types at startup {}", packagesList);
        } else if (AutoConfigurationPackages.has((BeanFactory)this.appContext)) {
            packagesList = AutoConfigurationPackages.get((BeanFactory)this.appContext);
        }
        return packagesList;
    }

    private List<String> getLookupPackages() {
        return Stream.concat(this.getDefaultPackages().stream(), Stream.of("com.vaadin.fusion.frontend", "com.vaadin.flow.component.polymertemplate.rpc", "com.vaadin.base.devserver")).collect(Collectors.toList());
    }

    private static void collectHandleTypes(Class<?> clazz, List<Class<? extends Annotation>> annotations, List<Class<?>> superTypes) {
        HandlesTypes handlesTypes = clazz.getAnnotation(HandlesTypes.class);
        assert (handlesTypes != null);
        VaadinServletContextInitializer.collectHandleTypes(handlesTypes.value(), annotations, superTypes);
    }

    private static void collectHandleTypes(Class<?>[] handleTypes, List<Class<? extends Annotation>> annotations, List<Class<?>> superTypes) {
        assert (handleTypes != null);
        for (Class<?> type : handleTypes) {
            if (type.isAnnotation()) {
                annotations.add(type);
                continue;
            }
            superTypes.add(type);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinServletContextInitializer.class);
    }

    static /* synthetic */ List access$2600() {
        return DEFAULT_SCAN_NEVER;
    }

    private static class CustomResourceLoader
    extends PathMatchingResourcePatternResolver {
        private final PrefixTree scanNever = new PrefixTree(VaadinServletContextInitializer.access$2600());
        private final PrefixTree scanAlways = new PrefixTree(VaadinServletContextInitializer.access$1300().stream().map(packageName -> packageName.replace('.', '/')).collect(Collectors.toList()));
        private final ReentrantLock lock = new ReentrantLock(true);
        private Map<String, Resource[]> cache = new HashMap<String, Resource[]>();
        private Set<String> rootPaths = new HashSet<String>();

        public CustomResourceLoader(ResourceLoader resourceLoader, List<String> addedScanNever) {
            super(resourceLoader);
            Objects.requireNonNull(addedScanNever, "addedScanNever shouldn't be null!");
            addedScanNever.forEach(this.scanNever::addPrefix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource[] getResources(String locationPattern) throws IOException {
            this.lock.lock();
            try {
                if (this.cache.containsKey(locationPattern)) {
                    Resource[] resourceArray = this.cache.get(locationPattern);
                    return resourceArray;
                }
                Resource[] resources = this.collectResources(locationPattern);
                this.cache.put(locationPattern, resources);
                Resource[] resourceArray = resources;
                return resourceArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Resource[] collectResources(String locationPattern) throws IOException {
            ArrayList<Resource> resourcesList = new ArrayList<Resource>();
            for (Resource resource : super.getResources(locationPattern)) {
                String path = resource.getURL().getPath();
                if (path.endsWith(".jar!/")) {
                    resourcesList.add(resource);
                    continue;
                }
                if (path.endsWith("/")) {
                    this.rootPaths.add(path);
                    resourcesList.add(resource);
                    continue;
                }
                int index = path.lastIndexOf(".jar!/");
                if (index >= 0) {
                    String relativePath = path.substring(index + 6);
                    if (!this.shouldPathBeScanned(relativePath)) continue;
                    resourcesList.add(resource);
                    continue;
                }
                List parents = this.rootPaths.stream().filter(path::startsWith).collect(Collectors.toList());
                if (parents.isEmpty()) {
                    throw new IllegalStateException(String.format("Parent resource of [%s] not found in the resources!", path));
                }
                if (!parents.stream().anyMatch(parent -> this.shouldPathBeScanned(path.substring(parent.length())))) continue;
                resourcesList.add(resource);
            }
            return resourcesList.toArray(new Resource[0]);
        }

        private boolean shouldPathBeScanned(String path) {
            return this.scanAlways.hasPrefix(path) || !this.scanNever.hasPrefix(path);
        }
    }

    private class VaadinAppShellContextListener
    implements FailFastServletContextListener {
        private VaadinAppShellContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            long start = System.nanoTime();
            ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)new VaadinServletContext(event.getServletContext()));
            if (config == null || config.useV14Bootstrap()) {
                return;
            }
            Set classes = VaadinServletContextInitializer.this.findByAnnotationOrSuperType(VaadinServletContextInitializer.this.getVerifiableAnnotationPackages(), VaadinServletContextInitializer.this.customLoader, VaadinAppShellInitializer.getValidAnnotations(), VaadinAppShellInitializer.getValidSupers()).collect(Collectors.toSet());
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().info("Search for VaadinAppShell took {} ms", (Object)ms);
            VaadinAppShellInitializer.init(classes, (ServletContext)event.getServletContext());
        }
    }

    private class WebComponentServletContextListener
    implements FailFastServletContextListener {
        private WebComponentServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            if (registry.getConfigurations() == null || registry.getConfigurations().isEmpty()) {
                WebComponentConfigurationRegistryInitializer initializer = new WebComponentConfigurationRegistryInitializer();
                Set webComponentExporters = VaadinServletContextInitializer.this.findBySuperType(VaadinServletContextInitializer.this.getWebComponentPackages(), WebComponentExporter.class).collect(Collectors.toSet());
                initializer.process(webComponentExporters, event.getServletContext());
            }
        }
    }

    private class DevModeServletContextListener
    implements FailFastServletContextListener {
        private transient DevModeHandlerManager devModeHandlerManager;

        private DevModeServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            VaadinServletContext vaadinContext = new VaadinServletContext(event.getServletContext());
            ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)new VaadinServletContext(event.getServletContext()));
            if (config == null || config.isProductionMode() || !config.enableDevServer()) {
                return;
            }
            Lookup lookup = (Lookup)vaadinContext.getAttribute(Lookup.class);
            this.devModeHandlerManager = (DevModeHandlerManager)lookup.lookup(DevModeHandlerManager.class);
            if (this.devModeHandlerManager == null) {
                throw new RuntimeException("no DevModeHandlerManager implementation found but but dev server enabled. Either disable by setting vaadin.enableDevServer=false (and run the build-frontend maven goal) or include the vaadin-dev-server dependency");
            }
            if (this.isDevModeAlreadyStarted(event.getServletContext())) {
                return;
            }
            Set<String> basePackages = this.isScanOnlySet() ? new HashSet<String>(this.getScanOnlyPackages()) : Collections.singleton("");
            long start = System.nanoTime();
            ArrayList annotations = new ArrayList();
            ArrayList superTypes = new ArrayList();
            VaadinServletContextInitializer.collectHandleTypes(this.devModeHandlerManager.getHandlesTypes(), (List<Class<? extends Annotation>>)annotations, superTypes);
            Set classes = VaadinServletContextInitializer.this.findByAnnotationOrSuperType(basePackages, VaadinServletContextInitializer.this.customLoader, annotations, superTypes).collect(Collectors.toSet());
            long ms = (System.nanoTime() - start) / 1000000L;
            VaadinServletContextInitializer.getLogger().info("Search for subclasses and classes with annotations took {} ms", (Object)ms);
            try {
                this.devModeHandlerManager.initDevModeHandler(classes, (VaadinContext)new VaadinServletContext(event.getServletContext()));
            }
            catch (VaadinInitializerException e) {
                throw new RuntimeException("Unable to initialize Vaadin DevModeHandler", e);
            }
            ServletDeployer.logAppStartupToConsole((ServletContext)event.getServletContext(), (boolean)true);
        }

        public void contextDestroyed(ServletContextEvent sce) {
            if (this.devModeHandlerManager != null) {
                DevModeHandler devModeHandler = this.devModeHandlerManager.getDevModeHandler();
                devModeHandler.stop();
            }
        }

        private Collection<String> getScanOnlyPackages() {
            HashSet<String> npmPackages = new HashSet<String>(VaadinServletContextInitializer.this.getDefaultPackages());
            npmPackages.addAll(DEFAULT_SCAN_ONLY);
            if (VaadinServletContextInitializer.this.customScanOnly != null) {
                npmPackages.addAll(VaadinServletContextInitializer.this.customScanOnly);
            }
            return npmPackages;
        }

        private boolean isScanOnlySet() {
            return VaadinServletContextInitializer.this.customScanOnly != null && !VaadinServletContextInitializer.this.customScanOnly.isEmpty();
        }

        private boolean isDevModeAlreadyStarted(ServletContext servletContext) {
            VaadinServletContext vaadinContext;
            if (this.devModeHandlerManager != null && this.devModeHandlerManager.isDevModeAlreadyStarted((VaadinContext)(vaadinContext = new VaadinServletContext(servletContext)))) {
                if (VaadinServletContextInitializer.getLogger().isDebugEnabled()) {
                    VaadinServletContextInitializer.getLogger().debug("Skipped DevModeHandler initialization as it has been already initialized");
                }
                return true;
            }
            return false;
        }
    }

    private class AnnotationValidatorServletContextListener
    implements FailFastServletContextListener {
        private AnnotationValidatorServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            AnnotationValidator annotationValidator = new AnnotationValidator();
            this.validateAnnotations((ClassLoaderAwareServletContainerInitializer)annotationValidator, event.getServletContext(), annotationValidator.getAnnotations());
            WebComponentExporterAwareValidator extraValidator = new WebComponentExporterAwareValidator();
            this.validateAnnotations((ClassLoaderAwareServletContainerInitializer)extraValidator, event.getServletContext(), extraValidator.getAnnotations());
        }

        private void validateAnnotations(ClassLoaderAwareServletContainerInitializer initializer, ServletContext context, List<Class<?>> annotations) {
            Stream annotatedClasses = VaadinServletContextInitializer.this.findByAnnotation((Collection<String>)VaadinServletContextInitializer.this.getVerifiableAnnotationPackages(), annotations.toArray(new Class[annotations.size()]));
            Set set = annotatedClasses.collect(Collectors.toSet());
            try {
                initializer.process(set, context);
            }
            catch (ServletException exception) {
                throw new RuntimeException("Unexpected servlet exception from " + initializer.getClass() + " validator", exception);
            }
        }
    }

    private class ErrorParameterServletContextListener
    implements FailFastServletContextListener {
        private ErrorParameterServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            Stream<Class> hasErrorComponents = VaadinServletContextInitializer.this.findBySuperType(VaadinServletContextInitializer.this.getErrorParameterPackages(), HasErrorParameter.class).filter(Component.class::isAssignableFrom).map(clazz -> clazz);
            registry.setErrorNavigationTargets(hasErrorComponents.collect(Collectors.toSet()));
        }
    }

    private class RouteServletContextListener
    extends AbstractRouteRegistryInitializer
    implements FailFastServletContextListener {
        private RouteServletContextListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) {
            ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext(event.getServletContext()));
            VaadinServletContextInitializer.getLogger().debug("Servlet Context initialized. Running route discovering....");
            if (registry.getRegisteredRoutes().isEmpty()) {
                VaadinServletContextInitializer.getLogger().debug("There are no discovered routes yet. Start to collect all routes from the classpath...");
                try {
                    List routeClasses = VaadinServletContextInitializer.this.findByAnnotation((Collection<String>)VaadinServletContextInitializer.this.getRoutePackages(), new Class[]{Route.class, RouteAlias.class}).collect(Collectors.toList());
                    VaadinServletContextInitializer.getLogger().debug("Found {} route classes. Here is the list: {}", (Object)routeClasses.size(), routeClasses);
                    Set navigationTargets = this.validateRouteClasses(routeClasses.stream());
                    VaadinServletContextInitializer.getLogger().debug("There are {} navigation targets after filtering route classes: {}", (Object)navigationTargets.size(), (Object)navigationTargets);
                    RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)registry);
                    routeConfiguration.update((Command & Serializable)() -> this.setAnnotatedRoutes(routeConfiguration, navigationTargets));
                    registry.setPwaConfigurationClass(this.validatePwaClass(routeClasses.stream()));
                }
                catch (InvalidRouteConfigurationException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                VaadinServletContextInitializer.getLogger().debug("Skipped discovery as there was {} routes already in registry", (Object)registry.getRegisteredRoutes().size());
            }
        }

        private void setAnnotatedRoutes(RouteConfiguration routeConfiguration, Set<Class<? extends Component>> routes) {
            routeConfiguration.getHandledRegistry().clean();
            for (Class<? extends Component> navigationTarget : routes) {
                try {
                    routeConfiguration.setAnnotatedRoute(navigationTarget);
                }
                catch (AmbiguousRouteConfigurationException exception) {
                    if (this.handleAmbiguousRoute(routeConfiguration, exception.getConfiguredNavigationTarget(), navigationTarget)) continue;
                    throw exception;
                }
            }
        }

        private boolean handleAmbiguousRoute(RouteConfiguration routeConfiguration, Class<? extends Component> configuredNavigationTarget, Class<? extends Component> navigationTarget) {
            if (GenericTypeReflector.isSuperType(navigationTarget, configuredNavigationTarget)) {
                return true;
            }
            if (GenericTypeReflector.isSuperType(configuredNavigationTarget, navigationTarget)) {
                routeConfiguration.removeRoute(configuredNavigationTarget);
                routeConfiguration.setAnnotatedRoute(navigationTarget);
                return true;
            }
            return false;
        }
    }

    private class LookupInitializerListener
    extends LookupServletContainerInitializer
    implements FailFastServletContextListener {
        private LookupInitializerListener() {
        }

        @Override
        public void failFastContextInitialized(ServletContextEvent event) throws ServletException {
            VaadinServletContext vaadinContext = new VaadinServletContext(event.getServletContext());
            if (vaadinContext.getAttribute(Lookup.class) != null) {
                return;
            }
            Set classes = Stream.concat(VaadinServletContextInitializer.this.findByAnnotationOrSuperType(VaadinServletContextInitializer.this.getLookupPackages(), (ResourceLoader)VaadinServletContextInitializer.this.appContext, Collections.emptyList(), this.getServiceTypes()), Stream.of(LookupInitializer.class, SpringLookupInitializer.class)).collect(Collectors.toSet());
            this.process(classes, event.getServletContext());
        }

        protected Collection<Class<?>> getServiceTypes() {
            List annotations = Collections.emptyList();
            LinkedList types = new LinkedList();
            VaadinServletContextInitializer.collectHandleTypes(LookupServletContainerInitializer.class, (List<Class<? extends Annotation>>)annotations, types);
            types.remove(LookupInitializer.class);
            return types;
        }
    }

    private static class CompositeServletContextListener
    implements ServletContextListener,
    Serializable {
        private final List<FailFastServletContextListener> listeners = new ArrayList<FailFastServletContextListener>();

        private CompositeServletContextListener() {
        }

        public void contextInitialized(ServletContextEvent event) {
            this.listeners.forEach(listener -> listener.contextInitialized(event));
        }

        public void contextDestroyed(ServletContextEvent event) {
            this.listeners.forEach(listener -> listener.contextDestroyed(event));
        }

        private void addListener(FailFastServletContextListener listener) {
            this.listeners.add(listener);
        }
    }

    private static interface FailFastServletContextListener
    extends ServletContextListener,
    Serializable {
        public static final String ATTR = "failed-" + FailFastServletContextListener.class.getName();

        default public void contextInitialized(ServletContextEvent event) {
            if (event.getServletContext().getAttribute(ATTR) == null) {
                try {
                    this.failFastContextInitialized(event);
                }
                catch (Exception e) {
                    event.getServletContext().setAttribute(ATTR, (Object)true);
                    throw new RuntimeException("Unable to initialize " + this.getClass().getName(), e);
                }
            }
        }

        public void failFastContextInitialized(ServletContextEvent var1) throws ServletException;
    }

    private static class ClassPathScanner
    extends ClassPathScanningCandidateComponentProvider {
        private ClassPathScanner(Environment environment, ResourceLoader resourceLoader, Collection<Class<? extends Annotation>> annotations, Collection<Class<?>> types) {
            super(false, environment);
            this.setResourceLoader(resourceLoader);
            annotations.stream().map(AnnotationTypeFilter::new).forEach(arg_0 -> ((ClassPathScanner)this).addIncludeFilter(arg_0));
            types.stream().map(AssignableTypeFilter::new).forEach(arg_0 -> ((ClassPathScanner)this).addIncludeFilter(arg_0));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return super.isCandidateComponent(beanDefinition) || beanDefinition.getMetadata().isAbstract();
        }
    }
}

