/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.spring.security.RequestUtil;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class VaadinWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Autowired
    private VaadinDefaultRequestCache vaadinDefaultRequestCache;
    @Autowired
    private RequestUtil requestUtil;
    @Autowired
    private ViewAccessChecker viewAccessChecker;

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().requestMatchers(new RequestMatcher[]{VaadinWebSecurityConfigurerAdapter.getDefaultWebSecurityIgnoreMatcher()});
    }

    protected void configure(HttpSecurity http) throws Exception {
        RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
        requestMatcherArray[0] = this.requestUtil::isFrameworkInternalRequest;
        http.csrf().ignoringRequestMatchers(requestMatcherArray);
        RequestMatcher[] requestMatcherArray2 = new RequestMatcher[1];
        requestMatcherArray2[0] = this.requestUtil::isEndpointRequest;
        http.csrf().ignoringRequestMatchers(requestMatcherArray2);
        http.requestCache().requestCache((RequestCache)this.vaadinDefaultRequestCache);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry urlRegistry = http.authorizeRequests();
        RequestMatcher[] requestMatcherArray3 = new RequestMatcher[1];
        requestMatcherArray3[0] = this.requestUtil::isFrameworkInternalRequest;
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray3)).permitAll();
        RequestMatcher[] requestMatcherArray4 = new RequestMatcher[1];
        requestMatcherArray4[0] = this.requestUtil::isAnonymousEndpoint;
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray4)).permitAll();
        RequestMatcher[] requestMatcherArray5 = new RequestMatcher[1];
        requestMatcherArray5[0] = this.requestUtil::isAnonymousRoute;
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray5)).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{VaadinWebSecurityConfigurerAdapter.getDefaultHttpSecurityPermitMatcher()})).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        this.viewAccessChecker.enable();
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher() {
        Stream<String> flowProvided = Stream.of(HandlerHelper.getPublicResourcesRequiringSecurityContext());
        Stream<String> other = Stream.of("/vaadinServlet/**");
        return new OrRequestMatcher(Stream.concat(flowProvided, other).map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher() {
        return new OrRequestMatcher(Stream.of(HandlerHelper.getPublicResources()).map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    protected void setLoginView(HttpSecurity http, String fusionLoginViewPath) throws Exception {
        this.setLoginView(http, fusionLoginViewPath, "/");
    }

    protected void setLoginView(HttpSecurity http, String fusionLoginViewPath, String logoutUrl) throws Exception {
        FormLoginConfigurer formLogin = http.formLogin();
        formLogin.loginPage(fusionLoginViewPath).permitAll();
        formLogin.successHandler((AuthenticationSuccessHandler)new VaadinSavedRequestAwareAuthenticationSuccessHandler());
        http.logout().logoutSuccessUrl(logoutUrl);
        this.viewAccessChecker.setLoginView(fusionLoginViewPath);
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView) throws Exception {
        this.setLoginView(http, flowLoginView, "/");
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView, String logoutUrl) throws Exception {
        Optional route = AnnotationReader.getAnnotationFor(flowLoginView, Route.class);
        if (!route.isPresent()) {
            throw new IllegalArgumentException("Unable find a @Route annotation on the login view " + flowLoginView.getName());
        }
        String loginPath = RouteUtil.getRoutePath(flowLoginView, (Route)((Route)route.get()));
        if (!loginPath.startsWith("/")) {
            loginPath = "/" + loginPath;
        }
        FormLoginConfigurer formLogin = http.formLogin();
        formLogin.loginPage(loginPath).permitAll();
        formLogin.successHandler((AuthenticationSuccessHandler)new VaadinSavedRequestAwareAuthenticationSuccessHandler());
        http.csrf().ignoringAntMatchers(new String[]{loginPath});
        http.logout().logoutSuccessUrl(logoutUrl);
        this.viewAccessChecker.setLoginView(flowLoginView);
    }
}

