/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import com.vaadin.fusion.EndpointUtil;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RequestUtil {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AccessAnnotationChecker accessAnnotationChecker;
    @Autowired
    private VaadinConfigurationProperties configurationProperties;
    private Object endpointUtil;
    @Autowired
    private ServletRegistrationBean<SpringServlet> springServletRegistration;

    @PostConstruct
    public void init() {
        try {
            this.endpointUtil = this.applicationContext.getBean(EndpointUtil.class);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isFrameworkInternalRequest(HttpServletRequest request) {
        String vaadinMapping = this.configurationProperties.getUrlMapping();
        return HandlerHelper.isFrameworkInternalRequest((String)vaadinMapping, (HttpServletRequest)request);
    }

    public boolean isEndpointRequest(HttpServletRequest request) {
        if (this.endpointUtil != null) {
            return ((EndpointUtil)this.endpointUtil).isEndpointRequest(request);
        }
        return false;
    }

    public boolean isAnonymousEndpoint(HttpServletRequest request) {
        if (this.endpointUtil != null) {
            return ((EndpointUtil)this.endpointUtil).isAnonymousEndpoint(request);
        }
        return false;
    }

    public boolean isAnonymousRoute(HttpServletRequest request) {
        SpringServlet servlet;
        VaadinServletService service;
        Router router;
        RouteRegistry routeRegistry;
        NavigationRouteTarget target;
        String requestedPath;
        String vaadinMapping = this.configurationProperties.getUrlMapping();
        Optional maybePath = HandlerHelper.getPathIfInsideServlet((String)vaadinMapping, (String)(requestedPath = RequestUtil.getRequestPathInsideContext(request)));
        if (!maybePath.isPresent()) {
            return false;
        }
        String path = (String)maybePath.get();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((target = (routeRegistry = (router = (service = (servlet = (SpringServlet)this.springServletRegistration.getServlet()).getService()).getRouter()).getRegistry()).getNavigationRouteTarget(path)) == null) {
            return false;
        }
        RouteTarget routeTarget = target.getRouteTarget();
        if (routeTarget == null) {
            return false;
        }
        Class targetView = routeTarget.getTarget();
        if (targetView == null) {
            return false;
        }
        boolean result = this.accessAnnotationChecker.hasAccess(targetView, null, role -> false);
        if (result) {
            this.getLogger().debug(path + " refers to a public view");
        }
        return result;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private static String getRequestPathInsideContext(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String url = "";
        if (servletPath != null) {
            url = url + servletPath;
        }
        if (pathInfo != null) {
            url = url + pathInfo;
        }
        return url;
    }
}

