/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.base.devserver.util.BrowserLauncher;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import java.io.Serializable;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class DevModeBrowserLauncher
implements SpringApplicationRunListener,
Serializable {
    private static final String LAUNCH_TRACKER = "LaunchUtil.hasLaunched";
    private static final String LAUNCHED_VALUE = "yes";

    public DevModeBrowserLauncher(SpringApplication application, String[] arguments) {
    }

    public void running(ConfigurableApplicationContext context) {
        try {
            VaadinConfigurationProperties properties = (VaadinConfigurationProperties)context.getBean(VaadinConfigurationProperties.class);
            if (properties.isLaunchBrowser()) {
                this.launchBrowserInDevelopmentMode((ApplicationContext)context);
            }
        }
        catch (Exception e) {
            DevModeBrowserLauncher.getLogger().debug("Failed to launch browser", (Throwable)e);
        }
    }

    private void launchBrowserInDevelopmentMode(ApplicationContext appContext) {
        if (DevModeBrowserLauncher.isLaunched()) {
            return;
        }
        if (!(appContext instanceof GenericWebApplicationContext)) {
            DevModeBrowserLauncher.getLogger().warn("Unable to determine production mode for an Spring Boot application context of type " + appContext.getClass().getName());
            return;
        }
        GenericWebApplicationContext webAppContext = (GenericWebApplicationContext)appContext;
        if (!DevModeBrowserLauncher.isProductionMode(webAppContext)) {
            String location = DevModeBrowserLauncher.getUrl(webAppContext);
            String outputOnFailure = "Application started at " + location;
            try {
                BrowserLauncher.launch((String)location, (String)outputOnFailure);
                DevModeBrowserLauncher.setLaunched();
            }
            catch (Exception | NoClassDefFoundError e) {
                DevModeBrowserLauncher.getLogger().info(outputOnFailure);
            }
        }
    }

    static String getUrl(GenericWebApplicationContext app) {
        String contextPath;
        String port = app.getEnvironment().getProperty("server.port");
        String host = "http://localhost:" + port;
        Object path = "/";
        String vaadinServletMapping = app.getEnvironment().getProperty("vaadin.urlMapping");
        ServletContext servletContext = app.getServletContext();
        if (servletContext != null && (contextPath = servletContext.getContextPath()) != null && !contextPath.isEmpty()) {
            path = contextPath + "/";
        }
        if (vaadinServletMapping != null && !vaadinServletMapping.isEmpty()) {
            if (vaadinServletMapping.startsWith("/")) {
                vaadinServletMapping = vaadinServletMapping.substring(1);
            }
            if (vaadinServletMapping.endsWith("*")) {
                vaadinServletMapping = vaadinServletMapping.substring(0, vaadinServletMapping.length() - 1);
            }
            path = (String)path + vaadinServletMapping;
        }
        return host + (String)path;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeBrowserLauncher.class);
    }

    private static boolean isProductionMode(GenericWebApplicationContext app) {
        ServletContext servletContext = app.getServletContext();
        VaadinServletContext context = new VaadinServletContext(servletContext);
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)context);
        return applicationConfiguration.isProductionMode();
    }

    private static boolean isLaunched() {
        return LAUNCHED_VALUE.equals(System.getProperty(LAUNCH_TRACKER));
    }

    private static void setLaunched() {
        System.setProperty(LAUNCH_TRACKER, LAUNCHED_VALUE);
    }
}

