/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.CompositeLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class AuthenticationContext
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationContext.class);
    private transient LogoutSuccessHandler logoutSuccessHandler;
    private transient CompositeLogoutHandler logoutHandler;

    public <U> Optional<U> getAuthenticatedUser(Class<U> userType) {
        return AuthenticationContext.getAuthentication().map(Authentication::getPrincipal).map(userType::cast);
    }

    public Optional<String> getPrincipalName() {
        return AuthenticationContext.getAuthentication().map(Principal::getName);
    }

    public boolean isAuthenticated() {
        return AuthenticationContext.getAuthentication().map(Authentication::isAuthenticated).orElse(false);
    }

    public void logout() {
        HttpServletRequest request = VaadinServletRequest.getCurrent().getHttpServletRequest();
        HttpServletResponse response = VaadinServletResponse.getCurrent().getHttpServletResponse();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UI ui = UI.getCurrent();
        this.logoutHandler.logout(request, response, auth);
        ui.accessSynchronously((Command & Serializable)() -> {
            try {
                this.logoutSuccessHandler.onLogoutSuccess(request, response, auth);
            }
            catch (IOException | ServletException e) {
                LOGGER.warn("There was an error notifying the logout handler about the user logout", e);
            }
        });
    }

    void setLogoutHandlers(LogoutSuccessHandler logoutSuccessHandler, List<LogoutHandler> logoutHandlers) {
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.logoutHandler = new CompositeLogoutHandler(logoutHandlers);
    }

    private static Optional<Authentication> getAuthentication() {
        return Optional.of(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).filter(auth -> !(auth instanceof AnonymousAuthenticationToken));
    }

    LogoutSuccessHandler getLogoutSuccessHandler() {
        return this.logoutSuccessHandler;
    }

    CompositeLogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }
}

