/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.springnative;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouterLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;

public class VaadinBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.findAndRegisterRoutes((BeanDefinitionRegistry)beanFactory);
        } else {
            this.logger.error("Unable to register @Route classes as beans because the used bean factory is of type {} which does not implement {}", (Object)beanFactory.getClass().getName(), (Object)BeanDefinitionRegistry.class.getName());
        }
        return (generationContext, beanFactoryInitializationCode) -> {
            RuntimeHints hints = generationContext.getRuntimeHints();
            for (String pkg : VaadinBeanFactoryInitializationAotProcessor.getPackages((BeanFactory)beanFactory)) {
                Reflections reflections = new Reflections(pkg, new Scanner[0]);
                for (Class<Object> c : VaadinBeanFactoryInitializationAotProcessor.getRouteTypesFor(reflections, pkg)) {
                    this.registerType(hints, c);
                    this.registerResources(hints, c);
                }
                for (Class<Object> c : reflections.getSubTypesOf(AppShellConfigurator.class)) {
                    this.registerType(hints, c);
                    this.registerResources(hints, c);
                }
                this.registerSubTypes(hints, reflections, Component.class);
                this.registerSubTypes(hints, reflections, RouterLayout.class);
                this.registerSubTypes(hints, reflections, HasErrorParameter.class);
                this.registerSubTypes(hints, reflections, ComponentEvent.class);
                this.registerSubTypes(hints, reflections, HasUrlParameter.class);
                this.registerSubTypes(hints, reflections, "com.vaadin.flow.data.converter.Converter");
            }
        };
    }

    private void registerSubTypes(RuntimeHints hints, Reflections reflections, Class<?> cls) {
        for (Class c : reflections.getSubTypesOf(cls)) {
            this.registerType(hints, c);
        }
    }

    private void registerSubTypes(RuntimeHints hints, Reflections reflections, String className) {
        try {
            Class<?> cls = Class.forName(className);
            for (Class c : reflections.getSubTypesOf(cls)) {
                this.registerType(hints, c);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    private static List<String> getPackagesWithRoutes(BeanFactory beanFactory) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("com.vaadin");
        packages.addAll(AutoConfigurationPackages.get((BeanFactory)beanFactory));
        return packages;
    }

    private <T extends BeanFactory & BeanDefinitionRegistry> void findAndRegisterRoutes(T beanFactory) {
        String markerBeanName = Marker.class.getName();
        this.logger.debug("Finding and registering routes");
        if (((BeanDefinitionRegistry)beanFactory).containsBeanDefinition(markerBeanName)) {
            this.logger.debug("Routes already registered");
            return;
        }
        HashSet<String> registeredClasses = new HashSet<String>();
        for (String beanName : ((BeanDefinitionRegistry)beanFactory).getBeanDefinitionNames()) {
            BeanDefinition def = ((BeanDefinitionRegistry)beanFactory).getBeanDefinition(beanName);
            if (def.getBeanClassName() == null) continue;
            registeredClasses.add(def.getBeanClassName());
        }
        for (String pkg : VaadinBeanFactoryInitializationAotProcessor.getPackagesWithRoutes(beanFactory)) {
            this.logger.debug("Scanning for @{} or @{} annotated beans in {}", new Object[]{Route.class.getSimpleName(), RouteAlias.class.getSimpleName(), pkg});
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            for (Class<?> c : VaadinBeanFactoryInitializationAotProcessor.getRouteTypesFor(reflections, pkg)) {
                if (registeredClasses.contains(c.getName())) {
                    this.logger.debug("Skipping route class {} as it has already been registered as a bean", (Object)c.getName());
                    continue;
                }
                registeredClasses.add(c.getName());
                this.logger.debug("Registering a bean for route class {}", (Object)c.getName());
                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(c).setScope("prototype").getBeanDefinition();
                ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(c.getName(), (BeanDefinition)beanDefinition);
            }
        }
        ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(markerBeanName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(Marker.class).getBeanDefinition());
    }

    private static Collection<Class<?>> getRouteTypesFor(Reflections reflections, String packageName) {
        HashSet routeTypes = new HashSet();
        routeTypes.addAll(reflections.getTypesAnnotatedWith(Route.class));
        routeTypes.addAll(reflections.getTypesAnnotatedWith(RouteAlias.class));
        return routeTypes;
    }

    private void registerResources(RuntimeHints hints, Class<?> c) {
        if (c.getCanonicalName() == null) {
            return;
        }
        hints.resources().registerType(c);
    }

    private void registerType(RuntimeHints hints, Class<?> c) {
        if (c.getCanonicalName() == null) {
            return;
        }
        MemberCategory[] memberCategories = MemberCategory.values();
        hints.reflection().registerType(c, memberCategories);
    }

    private static List<String> getPackages(BeanFactory beanFactory) {
        ArrayList<String> listOf = new ArrayList<String>();
        listOf.add("com.vaadin");
        listOf.addAll(AutoConfigurationPackages.get((BeanFactory)beanFactory));
        return listOf;
    }

    public static class Marker {
    }
}

