/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security.stateless;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import com.vaadin.flow.spring.security.stateless.JwtSecurityContextRepository;
import com.vaadin.flow.spring.security.stateless.SerializedJwtSplitCookieRepository;
import javax.crypto.SecretKey;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.savedrequest.CookieRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;

public final class VaadinStatelessSecurityConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<VaadinStatelessSecurityConfigurer<H>, H> {
    private long expiresIn = 1800L;
    private String issuer;
    private SecretKeyConfigurer secretKeyConfigurer;

    public void setSharedObjects(HttpSecurity http) {
        JwtSecurityContextRepository jwtSecurityContextRepository = new JwtSecurityContextRepository(new SerializedJwtSplitCookieRepository());
        http.setSharedObject(SecurityContextRepository.class, (Object)jwtSecurityContextRepository);
    }

    public void init(H http) {
        CsrfConfigurer csrf = (CsrfConfigurer)http.getConfigurer(CsrfConfigurer.class);
        if (csrf != null) {
            CookieCsrfTokenRepository csrfTokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
            XorCsrfTokenRequestAttributeHandler delegate = new XorCsrfTokenRequestAttributeHandler();
            CsrfTokenRequestHandler requestHandler = (arg_0, arg_1, arg_2) -> ((XorCsrfTokenRequestAttributeHandler)delegate).handle(arg_0, arg_1, arg_2);
            csrf.csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository);
            csrf.csrfTokenRequestHandler(requestHandler);
            ((VaadinSavedRequestAwareAuthenticationSuccessHandler)((Object)http.getSharedObject(VaadinSavedRequestAwareAuthenticationSuccessHandler.class))).setCsrfTokenRepository((CsrfTokenRepository)csrfTokenRepository);
        }
    }

    public void configure(H http) {
        RequestCache requestCache;
        SecurityContextRepository securityContextRepository = (SecurityContextRepository)http.getSharedObject(SecurityContextRepository.class);
        if (securityContextRepository instanceof JwtSecurityContextRepository) {
            JwtSecurityContextRepository jwtSecurityContextRepository = (JwtSecurityContextRepository)securityContextRepository;
            jwtSecurityContextRepository.setJwsAlgorithm(this.secretKeyConfigurer.getAlgorithm());
            jwtSecurityContextRepository.setJwkSource(this.secretKeyConfigurer.getJWKSource());
            jwtSecurityContextRepository.setIssuer(this.issuer);
            jwtSecurityContextRepository.setExpiresIn(this.expiresIn);
            AuthenticationTrustResolver trustResolver = (AuthenticationTrustResolver)http.getSharedObject(AuthenticationTrustResolver.class);
            if (trustResolver == null) {
                trustResolver = new AuthenticationTrustResolverImpl();
            }
            jwtSecurityContextRepository.setTrustResolver(trustResolver);
        }
        if ((requestCache = (RequestCache)http.getSharedObject(RequestCache.class)) instanceof VaadinDefaultRequestCache) {
            ((VaadinDefaultRequestCache)requestCache).setDelegateRequestCache((RequestCache)new CookieRequestCache());
        }
    }

    public VaadinStatelessSecurityConfigurer<H> expiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    public VaadinStatelessSecurityConfigurer<H> issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public SecretKeyConfigurer withSecretKey() {
        if (this.secretKeyConfigurer == null) {
            this.secretKeyConfigurer = new SecretKeyConfigurer();
        }
        return this.secretKeyConfigurer;
    }

    public VaadinStatelessSecurityConfigurer<H> withSecretKey(Customizer<SecretKeyConfigurer> customizer) {
        if (this.secretKeyConfigurer == null) {
            this.secretKeyConfigurer = new SecretKeyConfigurer();
        }
        customizer.customize((Object)this.secretKeyConfigurer);
        return this;
    }

    public class SecretKeyConfigurer {
        private SecretKey secretKey;
        private JwsAlgorithm jwsAlgorithm;

        private SecretKeyConfigurer() {
        }

        public SecretKeyConfigurer secretKey(SecretKey secretKey) {
            this.secretKey = secretKey;
            if (this.jwsAlgorithm == null) {
                this.jwsAlgorithm = MacAlgorithm.from((String)secretKey.getAlgorithm());
            }
            return this;
        }

        public SecretKeyConfigurer algorithm(MacAlgorithm algorithm) {
            this.jwsAlgorithm = algorithm;
            return this;
        }

        public VaadinStatelessSecurityConfigurer<H> and() {
            return VaadinStatelessSecurityConfigurer.this;
        }

        JWKSource<SecurityContext> getJWKSource() {
            OctetSequenceKey key = new OctetSequenceKey.Builder(this.secretKey).algorithm((Algorithm)this.getAlgorithm()).build();
            JWKSet jwkSet = new JWKSet((JWK)key);
            return (jwkSelector, context) -> jwkSelector.select(jwkSet);
        }

        JWSAlgorithm getAlgorithm() {
            return JWSAlgorithm.parse((String)this.jwsAlgorithm.getName());
        }
    }
}

