/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.i18n;

import com.vaadin.flow.i18n.DefaultI18NProvider;
import com.vaadin.flow.i18n.I18NUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DefaultI18NProviderFactory
implements Condition,
Serializable {
    public static final String DEFAULT_LOCATION_PATTERN = "classpath*:/vaadin-i18n/*.properties";

    public static DefaultI18NProvider create(String locationPattern) {
        try {
            Resource[] translations = DefaultI18NProviderFactory.getTranslationResources(locationPattern);
            if (translations.length > 0) {
                List locales = I18NUtil.collectLocalesFromFileNames(Arrays.stream(translations).map(Resource::getFilename).filter(Objects::nonNull).collect(Collectors.toList()));
                return new DefaultI18NProvider(locales);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(DefaultI18NProviderFactory.class).error("Unable to create DefaultI18NProvider instance.", (Throwable)e);
        }
        return null;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        try {
            String locationPattern = (String)context.getEnvironment().getProperty("vaadin.i18n.location-pattern", String.class, (Object)DEFAULT_LOCATION_PATTERN);
            Resource[] translations = DefaultI18NProviderFactory.getTranslationResources(locationPattern);
            return translations.length > 0;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(DefaultI18NProviderFactory.class).error("Unable to detect if DefaultI18NProvider instance is needed.", (Throwable)e);
            return false;
        }
    }

    private static Resource[] getTranslationResources(String locationPattern) throws IOException {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        return resourcePatternResolver.getResources(locationPattern != null ? locationPattern : DEFAULT_LOCATION_PATTERN);
    }
}

