/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.springnative;

import com.vaadin.flow.di.LookupInitializer;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class VaadinHintsRegistrar
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        ReflectionHints ref = hints.reflection();
        LookupInitializer.getDefaultImplementations().forEach(cls -> ref.registerType(cls, MemberCategory.values()));
        hints.resources().registerPattern("META-INF/VAADIN/*");
        hints.resources().registerPattern("vaadin-i18n/*");
        for (String cls2 : this.getClasses()) {
            hints.reflection().registerType(TypeReference.of((String)cls2), MemberCategory.values());
        }
        for (String componentClass : this.getCommonComponentClasses()) {
            hints.reflection().registerType(TypeReference.of((String)componentClass), MemberCategory.values());
        }
        this.registerResourceIfPresent(hints, "com/vaadin/flow/component/login/i18n.json");
        hints.resources().registerPattern("com/vaadin/flow/server/*");
        hints.resources().registerPattern("com/vaadin/flow/router/*");
    }

    private void registerResourceIfPresent(RuntimeHints hints, String path) {
        ClassPathResource res = new ClassPathResource(path);
        if (res.exists()) {
            hints.resources().registerResource((Resource)res);
        }
    }

    private String[] getCommonComponentClasses() {
        return new String[]{"com.vaadin.flow.component.login.LoginI18n", "com.vaadin.flow.component.login.LoginI18n$Form", "com.vaadin.flow.component.login.LoginI18n$ErrorMessage", "com.vaadin.flow.component.messages.MessageListItem"};
    }

    private String[] getClasses() {
        return new String[]{"org.apache.catalina.core.ApplicationContextFacade", "org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler$SupplierCsrfToken", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer", DefaultErrorHandler.class.getName()};
    }
}

