/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.server.auth.AccessCheckDecisionResolver;
import com.vaadin.flow.server.auth.AnnotatedViewAccessChecker;
import com.vaadin.flow.server.auth.DefaultAccessCheckDecisionResolver;
import com.vaadin.flow.server.auth.NavigationAccessChecker;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.RoutePathAccessChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class NavigationAccessControlConfigurer {
    private final List<NavigationAccessChecker> additionalCheckers = new ArrayList<NavigationAccessChecker>();
    private boolean disableAccessControl;
    private boolean enableViewAccessChecker;
    private boolean enablePathAccessChecker;
    private Class<? extends Component> loginView;
    private String loginViewPath;
    private AccessCheckDecisionResolver decisionResolver = new DefaultAccessCheckDecisionResolver();
    private Predicate<NavigationAccessChecker> accessCheckersFilter;

    public NavigationAccessControlConfigurer withAnnotatedViewAccessChecker() {
        this.enableViewAccessChecker = true;
        return this;
    }

    public NavigationAccessControlConfigurer withRoutePathAccessChecker() {
        this.enablePathAccessChecker = true;
        return this;
    }

    public NavigationAccessControlConfigurer withNavigationAccessChecker(NavigationAccessChecker accessChecker) {
        this.additionalCheckers.add(Objects.requireNonNull(accessChecker, "navigation access checker must not be null"));
        return this;
    }

    public NavigationAccessControlConfigurer withNavigationAccessCheckers(Collection<NavigationAccessChecker> accessChecker) {
        Objects.requireNonNull(accessChecker, "navigation access checker collection must not be null");
        this.additionalCheckers.addAll(accessChecker.stream().filter(Objects::nonNull).toList());
        return this;
    }

    public NavigationAccessControlConfigurer withAvailableNavigationAccessCheckers(Predicate<NavigationAccessChecker> filter) {
        Objects.requireNonNull(filter, "navigation access checker filter must not be null");
        this.accessCheckersFilter = filter;
        return this;
    }

    public NavigationAccessControlConfigurer withDecisionResolver(AccessCheckDecisionResolver resolver) {
        this.decisionResolver = Objects.requireNonNull(resolver, "Decision resolver must not be null");
        return this;
    }

    public NavigationAccessControlConfigurer disabled() {
        this.disableAccessControl = true;
        return this;
    }

    public NavigationAccessControlConfigurer withLoginView(Class<? extends Component> loginView) {
        this.loginView = loginView;
        return this;
    }

    public NavigationAccessControlConfigurer withLoginView(String loginViewPath) {
        this.loginViewPath = loginViewPath;
        return this;
    }

    public <T extends NavigationAccessControl> T build(BiFunction<List<NavigationAccessChecker>, AccessCheckDecisionResolver, T> factory, List<NavigationAccessChecker> availableCheckers) {
        Objects.requireNonNull(factory, "navigation access control factory must not be null");
        Objects.requireNonNull(availableCheckers, "available checkers list must not be null");
        ArrayList<NavigationAccessChecker> availableCopy = new ArrayList<NavigationAccessChecker>(availableCheckers);
        ArrayList<NavigationAccessChecker> checkerList = new ArrayList<NavigationAccessChecker>();
        if (this.enableViewAccessChecker) {
            checkerList.add(NavigationAccessControlConfigurer.extractRegisteredChecker(AnnotatedViewAccessChecker.class, availableCopy));
        }
        if (this.enablePathAccessChecker) {
            checkerList.add(NavigationAccessControlConfigurer.extractRegisteredChecker(RoutePathAccessChecker.class, availableCopy));
        }
        checkerList.addAll(this.additionalCheckers);
        availableCopy.removeAll(this.additionalCheckers);
        if (this.accessCheckersFilter != null) {
            availableCopy.stream().filter(this.accessCheckersFilter).collect(Collectors.toCollection(() -> checkerList));
        }
        NavigationAccessControl accessControl = (NavigationAccessControl)factory.apply(checkerList, this.decisionResolver);
        if (this.disableAccessControl) {
            accessControl.setEnabled(false);
        }
        if (this.loginView != null) {
            accessControl.setLoginView(this.loginView);
        }
        if (this.loginViewPath != null) {
            accessControl.setLoginView(this.loginViewPath);
        }
        return (T)accessControl;
    }

    private static NavigationAccessChecker extractRegisteredChecker(Class<? extends NavigationAccessChecker> checkerType, List<NavigationAccessChecker> checkerList) {
        NavigationAccessChecker result = checkerList.stream().filter(checker -> checkerType.equals(checker.getClass())).findFirst().orElseThrow(() -> new IllegalStateException(checkerType.getName() + " is not available"));
        checkerList.removeIf(checker -> checkerType.equals(checker.getClass()));
        return result;
    }
}

