/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.tabs.GeneratedVaadinTabs;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.TabsVariant;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

public class Tabs
extends GeneratedVaadinTabs<Tabs>
implements HasOrderedComponents,
HasSize {
    private static final String SELECTED = "selected";
    private transient Tab selectedTab;
    private boolean autoselect = true;

    public Tabs() {
        this.setSelectedIndex(-1);
        this.getElement().addPropertyChangeListener(SELECTED, (PropertyChangeListener & Serializable)event -> this.updateSelectedTab(event.isUserOriginated()));
    }

    public Tabs(Tab ... tabs) {
        this();
        this.add(tabs);
    }

    public Tabs(boolean autoselect, Tab ... tabs) {
        this();
        this.autoselect = autoselect;
        this.add(tabs);
    }

    public void add(Tab ... tabs) {
        this.add((Component[])tabs);
    }

    public void add(Component ... components) {
        boolean wasEmpty = this.getComponentCount() == 0;
        super.add(components);
        if (components.length == 0) {
            return;
        }
        if (wasEmpty && this.autoselect) {
            assert (this.getSelectedIndex() == -1);
            this.setSelectedIndex(0);
        } else {
            this.updateSelectedTab(false);
        }
    }

    public void remove(Component ... components) {
        int lowerIndices = (int)Stream.of(components).map(arg_0 -> ((Tabs)this).indexOf(arg_0)).filter(index -> index >= 0 && index < this.getSelectedIndex()).count();
        boolean isSelectedTab = Stream.of(components).anyMatch(component -> component.equals((Object)this.getSelectedTab()));
        super.remove(components);
        int newSelectedIndex = this.getSelectedIndex() - lowerIndices;
        if (newSelectedIndex > 0 && newSelectedIndex >= this.getComponentCount()) {
            newSelectedIndex = this.getComponentCount() - 1;
        }
        if (this.getComponentCount() == 0 || isSelectedTab && !this.isAutoselect()) {
            newSelectedIndex = -1;
        }
        if (newSelectedIndex != this.getSelectedIndex()) {
            this.setSelectedIndex(newSelectedIndex);
        } else {
            this.updateSelectedTab(false);
        }
    }

    public void removeAll() {
        super.removeAll();
        if (this.getSelectedIndex() > -1) {
            this.setSelectedIndex(-1);
        } else {
            this.updateSelectedTab(false);
        }
    }

    public void addComponentAtIndex(int index, Component component) {
        super.addComponentAtIndex(index, component);
        if (this.autoselect && this.getChildren().count() == 1L) {
            this.setSelectedIndex(0);
        } else if (index <= this.getSelectedIndex()) {
            this.setSelectedIndex(this.getSelectedIndex() + 1);
        }
    }

    public void replace(Component oldComponent, Component newComponent) {
        super.replace(oldComponent, newComponent);
        this.updateSelectedTab(false);
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJs("$0.addEventListener('items-changed', function(){ this.$server.updateSelectedTab(true); });", new Serializable[]{this.getElement()})));
    }

    public Registration addSelectedChangeListener(ComponentEventListener<SelectedChangeEvent> listener) {
        return this.addListener(SelectedChangeEvent.class, listener);
    }

    @Synchronize(property="selected", value={"selected-changed"})
    public int getSelectedIndex() {
        return this.getElement().getProperty(SELECTED, -1);
    }

    public void setSelectedIndex(int selectedIndex) {
        this.getElement().setProperty(SELECTED, (double)selectedIndex);
    }

    public Tab getSelectedTab() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        Component selectedComponent = this.getComponentAt(selectedIndex);
        if (!(selectedComponent instanceof Tab)) {
            throw new IllegalStateException("Illegal component inside Tabs: " + selectedComponent + ".Component should be an instance of Tab.");
        }
        return (Tab)selectedComponent;
    }

    public void setSelectedTab(Tab selectedTab) {
        if (selectedTab == null) {
            this.setSelectedIndex(-1);
            return;
        }
        int selectedIndex = this.indexOf(selectedTab);
        if (selectedIndex < 0) {
            throw new IllegalArgumentException("Tab to select must be a child: " + selectedTab);
        }
        this.setSelectedIndex(selectedIndex);
    }

    public Orientation getOrientation() {
        String orientation = this.getElement().getProperty("orientation");
        if (orientation != null) {
            return Orientation.valueOf(orientation.toUpperCase(Locale.ROOT));
        }
        return Orientation.HORIZONTAL;
    }

    public void setOrientation(Orientation orientation) {
        this.getElement().setProperty("orientation", orientation.name().toLowerCase(Locale.ENGLISH));
    }

    public void setFlexGrowForEnclosedTabs(double flexGrow) {
        if (flexGrow < 0.0) {
            throw new IllegalArgumentException("Flex grow property must not be negative");
        }
        this.getChildren().forEach(tab -> ((Tab)((Object)tab)).setFlexGrow(flexGrow));
    }

    public void setAutoselect(boolean autoselect) {
        this.autoselect = autoselect;
    }

    public boolean isAutoselect() {
        return this.autoselect;
    }

    @ClientCallable
    private void updateSelectedTab(boolean changedFromClient) {
        if (this.getSelectedIndex() < -1) {
            this.setSelectedIndex(-1);
            return;
        }
        Tab currentlySelected = this.getSelectedTab();
        Tab previousTab = this.selectedTab;
        if (Objects.equals((Object)currentlySelected, (Object)this.selectedTab)) {
            return;
        }
        if (currentlySelected == null || currentlySelected.isEnabled()) {
            this.selectedTab = currentlySelected;
            this.getChildren().filter(Tab.class::isInstance).map(Tab.class::cast).forEach(tab -> tab.setSelected(false));
            if (this.selectedTab != null) {
                this.selectedTab.setSelected(true);
            }
            this.fireEvent(new SelectedChangeEvent(this, previousTab, changedFromClient));
        } else {
            this.updateEnabled(currentlySelected);
            this.setSelectedTab(this.selectedTab);
        }
    }

    private void updateEnabled(Tab tab) {
        boolean enabled = tab.isEnabled();
        Serializable rawValue = tab.getElement().getPropertyRaw("disabled");
        if (rawValue instanceof Boolean) {
            tab.getElement().setProperty("disabled", enabled ? null : Boolean.TRUE.toString());
        } else {
            tab.setEnabled(enabled);
        }
    }

    @Override
    public void addThemeVariants(TabsVariant ... variants) {
        super.addThemeVariants(variants);
    }

    @Override
    public void removeThemeVariants(TabsVariant ... variants) {
        super.removeThemeVariants(variants);
    }

    public static class SelectedChangeEvent
    extends ComponentEvent<Tabs> {
        private final Tab selectedTab;
        private final Tab previousTab;
        private final boolean initialSelection;

        @Deprecated
        public SelectedChangeEvent(Tabs source, boolean fromClient) {
            this(source, null, fromClient);
        }

        public SelectedChangeEvent(Tabs source, Tab previousTab, boolean fromClient) {
            super((Component)source, fromClient);
            this.selectedTab = source.getSelectedTab();
            this.initialSelection = source.isAutoselect() && previousTab == null && !fromClient;
            this.previousTab = previousTab;
        }

        public Tab getSelectedTab() {
            return this.selectedTab;
        }

        public Tab getPreviousTab() {
            return this.previousTab;
        }

        public boolean isInitialSelection() {
            return this.initialSelection;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

