/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.tabs.TabVariant;

@Tag(value="vaadin-tab")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.5.6"), @NpmPackage(value="@vaadin/tabs", version="24.5.6")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/tabs/src/vaadin-tab.js")})
public class Tab
extends Component
implements HasAriaLabel,
HasComponents,
HasLabel,
HasStyle,
HasThemeVariant<TabVariant>,
HasTooltip {
    private static final String FLEX_GROW_CSS_PROPERTY = "flexGrow";

    public Tab() {
    }

    public Tab(String label) {
        this.setLabel(label);
    }

    public Tab(Component ... components) {
        this.add(components);
    }

    public final String getLabel() {
        return this.getElement().getText();
    }

    public final void setLabel(String label) {
        this.getElement().setText(label);
    }

    public void setFlexGrow(double flexGrow) {
        if (flexGrow < 0.0) {
            throw new IllegalArgumentException("Flex grow property cannot be negative");
        }
        if (flexGrow == 0.0) {
            this.getElement().getStyle().remove(FLEX_GROW_CSS_PROPERTY);
        } else {
            this.getElement().getStyle().set(FLEX_GROW_CSS_PROPERTY, String.valueOf(flexGrow));
        }
    }

    public double getFlexGrow() {
        String ratio = this.getElement().getStyle().get(FLEX_GROW_CSS_PROPERTY);
        if (ratio == null || ratio.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(ratio);
        }
        catch (Exception e) {
            throw new IllegalStateException("The flex grow property of the component is not parseable to double: " + ratio, e);
        }
    }

    public void setSelected(boolean selected) {
        this.getElement().setProperty("selected", selected);
    }

    public boolean isSelected() {
        return this.getElement().getProperty("selected", false);
    }

    public String toString() {
        return "Tab{" + this.getLabel() + "}";
    }
}

