/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import java.util.List;

import org.openqa.selenium.WebElement;

import com.vaadin.testbench.By;
import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.Button")
public class ButtonElement extends AbstractComponentElement {

    @Override
    public String getCaption() {
        WebElement captElem = findElement(By.className("v-button-caption"));
        return captElem.getText();
    }

    private boolean tryClickChild(WebElement e) {
        List<WebElement> children = e.findElements(By.xpath(".//*"));
        for (WebElement c : children) {
            if (c.isDisplayed()) {
                c.click();
                return true;
            } else {
                if (tryClickChild(c)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void click() {
        if (!isDisplayed()) {
            if (tryClickChild(this)) {
                return;
            }
        }

        super.click();
    }
}
