/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.Calendar")
@Deprecated
public class CalendarElement extends AbstractComponentElement {
    public List<WebElement> getWeekNumbers() {
        return findElements(By.className("v-calendar-week-number"));
    }

    public boolean hasMonthView() {
        return isElementPresent(By.className("v-calendar-week-numbers"));
    }

    public boolean hasWeekView() {
        return isElementPresent(By.className("v-calendar-header-week"));
    }

    public List<WebElement> getDayNumbers() {
        return findElements(By.className("v-calendar-day-number"));
    }

    public List<WebElement> getMonthDays() {
        return findElements(By.className("v-calendar-month-day"));
    }

    public boolean hasDayView() {
        return getDayHeaders().size() == 1;
    }

    public List<WebElement> getDayHeaders() {
        return findElements(By.className("v-calendar-header-day"));
    }

    public void back() {
        if (hasWeekView() || hasDayView()) {
            findElement(By.className("v-calendar-back")).click();
        } else {
            throw new IllegalStateException(
                    "Navigation only available in week or day view");
        }
    }

    public void next() {
        if (hasWeekView() || hasDayView()) {
            findElement(By.className("v-calendar-next")).click();
        } else {
            throw new IllegalStateException(
                    "Navigation only available in week or day view");
        }
    }

}
