/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.testbench.elements;

import org.openqa.selenium.Keys;

import com.vaadin.testbench.elementsbase.ServerClass;

@ServerClass("com.vaadin.ui.TextArea")
public class TextAreaElement extends AbstractTextFieldElement {
    /**
     * Return value of the field element.
     *
     * @since 8.0
     * @return value of the field element
     */
    @Override
    public String getValue() {
        return getAttribute("value");
    }

    @Override
    public void setValue(CharSequence chars) {
        if (isReadOnly()) {
            throw new ReadOnlyException();
        }
        // clears without triggering an event
        clearElementClientSide(this);
        focus();
        sendKeys(chars);
        sendKeys(Keys.TAB);
    }
}
