/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractSelectElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.CheckBoxGroup")
public class CheckBoxGroupElement
extends AbstractSelectElement {
    private static org.openqa.selenium.By bySelectOption = By.className((String)"v-select-option");
    private static org.openqa.selenium.By byLabel = By.tagName((String)"label");
    private static org.openqa.selenium.By byRadioInput = By.tagName((String)"input");

    public List<String> getOptions() {
        return this.getOptionElements().stream().map(option -> option.findElement(byLabel).getText()).collect(Collectors.toList());
    }

    public List<WebElement> getOptionElements() {
        return this.findElements(bySelectOption);
    }

    public void selectByText(String text) throws AbstractComponentElement.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException();
        }
        List options = this.findElements(bySelectOption);
        for (WebElement option : options) {
            if (!text.equals(option.findElement(byLabel).getText())) continue;
            WebElement input = option.findElement(byRadioInput);
            ((TestBenchElement)input).clickHiddenElement();
        }
    }

    public List<String> getValue() {
        ArrayList<String> values = new ArrayList<String>();
        List options = this.findElements(bySelectOption);
        for (WebElement option : options) {
            WebElement checkedItem = option.findElement(By.tagName((String)"input"));
            String checked = checkedItem.getAttribute("checked");
            if (checked == null || !checkedItem.getAttribute("checked").equals("true")) continue;
            values.add(option.findElement(By.tagName((String)"label")).getText());
        }
        return values;
    }

    public void setValue(String ... options) {
        this.setValue(Arrays.asList(options));
    }

    public void setValue(List<String> options) {
        this.getValue().stream().filter(option -> !options.contains(option)).forEach(this::selectByText);
        List<String> selection = this.getValue();
        options.stream().filter(option -> !selection.contains(option)).forEach(this::selectByText);
    }

    @Override
    public void clear() {
        super.clear();
    }
}

