/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.CyclicObjectWorkaround;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.TestBenchDriverProxy;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.annotations.Attribute;
import com.vaadin.testbench.elementsbase.Element;
import com.vaadin.testbench.internal.SharedUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ElementQuery<T extends TestBenchElement> {
    private Set<AttributeMatch> attributes = new LinkedHashSet<AttributeMatch>();
    private SearchContext searchContext;
    private final Class<T> elementClass;
    private final String tagName;

    public ElementQuery(Class<T> elementClass) {
        this(elementClass, ElementQuery.getTagName(elementClass));
    }

    public ElementQuery(Class<T> elementClass, String tagName) {
        this.elementClass = elementClass;
        this.tagName = tagName;
        this.attributes.addAll(ElementQuery.getAttributes(elementClass));
    }

    public T id(String id) {
        return this.attribute("id", id).first();
    }

    public ElementQuery<T> hasAttribute(String name) {
        this.attributes.add(new AttributeMatch(name));
        return this;
    }

    public ElementQuery<T> attribute(String name, String value) {
        this.attributes.add(new AttributeMatch(name, value));
        return this;
    }

    public ElementQuery<T> attributeContains(String name, String token) {
        this.attributes.add(new AttributeMatch(name, "~=", token));
        return this;
    }

    public ElementQuery<T> context(SearchContext searchContext) {
        this.searchContext = searchContext;
        return this;
    }

    public ElementQuery<T> onPage() {
        return this.context((SearchContext)this.getDriver());
    }

    protected SearchContext getContext() {
        return this.searchContext;
    }

    public T first() {
        return this.get(0);
    }

    public T waitForFirst() {
        Object result = new WebDriverWait(this.getDriver(), 10L).until(driver -> {
            try {
                return this.first();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        });
        if (result == null) {
            throw new NoSuchElementException(this.getNoSuchElementMessage(null));
        }
        return (T)((TestBenchElement)result);
    }

    private WebDriver getDriver() {
        if (this.getContext() instanceof WebDriver) {
            return (WebDriver)this.getContext();
        }
        return ((TestBenchElement)this.getContext()).getDriver();
    }

    public T last() {
        List<T> all = this.all();
        return (T)((TestBenchElement)all.get(all.size() - 1));
    }

    public T get(int index) {
        List<T> elements = this.executeSearch(index);
        if (elements.isEmpty()) {
            throw new NoSuchElementException(this.getNoSuchElementMessage(index));
        }
        return (T)((TestBenchElement)elements.get(0));
    }

    private String getNoSuchElementMessage(Integer index) {
        String msg = "No element with tag <" + this.tagName + "> found";
        String attrPairs = this.getAttributePairs();
        if (!attrPairs.isEmpty()) {
            msg = msg + " with the attributes " + attrPairs;
        }
        if (index != null) {
            msg = msg + " using index " + index;
        }
        return msg;
    }

    public boolean exists() {
        return !this.all().isEmpty();
    }

    public List<T> all() {
        return this.executeSearch(null);
    }

    private List<T> executeSearch(Integer index) {
        TestBenchDriverProxy executor;
        TestBenchElement elementContext;
        String indexSuffix = "";
        if (index != null) {
            indexSuffix = "[" + index + "]";
        }
        StringBuilder script = new StringBuilder();
        if (this.getContext() instanceof TestBenchElement) {
            script.append("var result = [];if (arguments[0].shadowRoot) {  var shadow = arguments[0].shadowRoot.querySelectorAll(arguments[1]+arguments[2]);  result = result.concat(Array.prototype.slice.call(shadow));}var light = arguments[0].querySelectorAll(arguments[1]+arguments[2]);result = result.concat(Array.prototype.slice.call(light));" + CyclicObjectWorkaround.get("result") + "return result");
            elementContext = (TestBenchElement)this.getContext();
            executor = elementContext.getCommandExecutor().getDriver();
        } else if (this.getContext() instanceof WebDriver) {
            script.append("var result = [];const queryResult = document.querySelectorAll(arguments[1]+arguments[2]);result = result.concat(Array.prototype.slice.call(queryResult));" + CyclicObjectWorkaround.get("result") + "return result");
            elementContext = null;
            executor = (JavascriptExecutor)this.getContext();
        } else {
            if (this.getContext() == null) {
                throw new IllegalStateException("Context cannot be null");
            }
            throw new IllegalStateException("Unknown context type: " + this.getContext().getClass().getName());
        }
        if (indexSuffix != null) {
            script.append(indexSuffix);
        }
        return this.executeSearchScript(script.toString(), elementContext, this.tagName, this.getAttributePairs(), executor);
    }

    private static String getTagName(Class<?> elementClass) {
        Element annotation = elementClass.getAnnotation(Element.class);
        if (annotation == null) {
            throw new IllegalStateException("The given element class " + elementClass.getName() + " must be annotated using @" + Element.class.getName());
        }
        return annotation.value();
    }

    static Set<AttributeMatch> getAttributes(Class<? extends TestBenchElement> elementClass) {
        Attribute[] attrs = (Attribute[])elementClass.getAnnotationsByType(Attribute.class);
        if (attrs == null) {
            return Collections.emptySet();
        }
        HashSet<AttributeMatch> classAttributes = new HashSet<AttributeMatch>();
        for (Attribute attr : attrs) {
            String value;
            if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attr.value())) {
                if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attr.contains())) {
                    throw new RuntimeException("You can only define either 'contains' or 'value' for an @" + Attribute.class.getSimpleName());
                }
                value = attr.value().equals("THE_CONVENTION_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!") ? ElementQuery.getClassConventionValue(elementClass) : attr.value();
                classAttributes.add(new AttributeMatch(attr.name(), "=", value));
                continue;
            }
            if (!"THE_DEFAULT_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!".equals(attr.contains())) {
                value = attr.contains().equals("THE_CONVENTION_VALUE_WHICH_YOU_SURELY_NEVER_EVER_WILL_USE_FOR_REAL, RIGHT?!") ? ElementQuery.getClassConventionValue(elementClass) : attr.contains();
                classAttributes.add(new AttributeMatch(attr.name(), "~=", value));
                continue;
            }
            classAttributes.add(new AttributeMatch(attr.name()));
        }
        return classAttributes;
    }

    private static String getClassConventionValue(Class<?> elementClass) {
        String value = elementClass.getSimpleName();
        value = value.replaceAll("(Element|PageObject)$", "");
        value = SharedUtil.camelCaseToDashSeparated(value).replaceAll("^-*", "");
        return value;
    }

    private String getAttributePairs() {
        return this.attributes.stream().map(AttributeMatch::getExpression).collect(Collectors.joining());
    }

    List<T> executeSearchScript(String script, Object context, String tagName, String attributePairs, JavascriptExecutor executor) {
        Object result = executor.executeScript(script, new Object[]{context, tagName, attributePairs});
        if (result == null) {
            return Collections.emptyList();
        }
        if (result instanceof TestBenchElement) {
            return Collections.singletonList(TestBench.wrap((TestBenchElement)result, this.elementClass));
        }
        List elements = (List)result;
        for (int i = 0; i < elements.size(); ++i) {
            T wrapped = TestBench.wrap((TestBenchElement)elements.get(i), this.elementClass);
            elements.set(i, wrapped);
        }
        return elements;
    }

    public static class AttributeMatch {
        private final String name;
        private final String operator;
        private final String value;

        public AttributeMatch(String name, String value) {
            this(name, "=", value);
        }

        public AttributeMatch(String name, String operator, String value) {
            this.name = name;
            this.operator = operator;
            this.value = value;
        }

        public AttributeMatch(String name) {
            this.name = name;
            this.operator = null;
            this.value = null;
        }

        public String toString() {
            return this.getExpression();
        }

        public String getExpression() {
            if (this.operator == null) {
                return "[" + this.name + "]";
            }
            return "[" + this.name + this.operator + "'" + AttributeMatch.escapeAttributeValue(this.value) + "']";
        }

        private static String escapeAttributeValue(String value) {
            return value.replace("'", "\\'");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AttributeMatch)) {
                return false;
            }
            return this.getExpression().equals(((AttributeMatch)obj).getExpression());
        }

        public int hashCode() {
            return this.getExpression().hashCode();
        }
    }
}

