/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel.setup;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.parallel.BrowserUtil;
import com.vaadin.testbench.parallel.ParallelTest;
import java.io.File;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;

public class LocalDriver {
    public static WebDriver createDriver() {
        return LocalDriver.createDriver(ParallelTest.getDefaultCapabilities().get(0));
    }

    public static WebDriver createDriver(DesiredCapabilities desiredCapabilities) {
        SafariDriver driver;
        if (BrowserUtil.isFirefox((Capabilities)desiredCapabilities)) {
            String firefoxPath = System.getProperty("firefox.path");
            String profilePath = System.getProperty("firefox.profile.path");
            FirefoxOptions options = new FirefoxOptions();
            if (firefoxPath != null) {
                options.setBinary(new FirefoxBinary(new File(firefoxPath)));
            }
            if (profilePath != null) {
                File profileDir = new File(profilePath);
                FirefoxProfile profile = new FirefoxProfile(profileDir);
                options.setProfile(profile);
            }
            options.setHeadless(Parameters.isHeadless());
            driver = new FirefoxDriver(options);
        } else if (BrowserUtil.isChrome((Capabilities)desiredCapabilities)) {
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"--test-type "});
            options.setHeadless(Parameters.isHeadless());
            driver = new ChromeDriver(options);
        } else if (BrowserUtil.isSafari((Capabilities)desiredCapabilities)) {
            driver = new SafariDriver();
        } else if (BrowserUtil.isEdge((Capabilities)desiredCapabilities)) {
            driver = new EdgeDriver();
        } else if (BrowserUtil.isIE((Capabilities)desiredCapabilities)) {
            driver = new InternetExplorerDriver();
        } else {
            throw new RuntimeException("Not implemented support for running locally on " + desiredCapabilities.getBrowserName());
        }
        return TestBench.createDriver((WebDriver)driver);
    }
}

