/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SauceLabsIntegration {
    private static final Logger logger = Logger.getLogger(SauceLabsIntegration.class.getName());
    private static final String SAUCE_DEFAULT_HUB_URL = "https://ondemand.us-west-1.saucelabs.com/wd/hub";
    private static final String SAUCE_USERNAME_ENV = "SAUCE_USERNAME";
    private static final String SAUCE_USERNAME_PROP = "sauce.user";
    private static final String SAUCE_ACCESS_KEY_ENV = "SAUCE_ACCESS_KEY";
    private static final String SAUCE_ACCESS_KEY_PROP = "sauce.sauceAccessKey";
    private static final String SAUCE_TUNNELID_PROP = "sauce.tunnelId";
    private static final String SAUCE_TUNNELID_ENV = "SAUCE_TUNNEL_ID";
    private static final String SAUCE_HUB_URL_PROP = "sauce.hubUrl";
    private static final String SAUCE_HUB_URL_ENV = "SAUCE_HUB_URL";

    public static void setDesiredCapabilities(DesiredCapabilities desiredCapabilities) {
        String username = SauceLabsIntegration.getSauceUser();
        String accessKey = SauceLabsIntegration.getSauceAccessKey();
        String tunnelId = SauceLabsIntegration.getSauceTunnelIdentifier();
        if (username != null) {
            SauceLabsIntegration.setSauceLabsOption(desiredCapabilities, "username", username);
        } else {
            logger.log(Level.FINE, "You can give a Sauce Labs user name using -Dsauce.user=<username> or by SAUCE_USERNAME environment variable.");
        }
        if (accessKey != null) {
            SauceLabsIntegration.setSauceLabsOption(desiredCapabilities, "access_key", accessKey);
        } else {
            logger.log(Level.FINE, "You can give a Sauce Labs access key using -Dsauce.sauceAccessKey=<accesskey> or by SAUCE_ACCESS_KEY environment variable.");
        }
        if (tunnelId != null) {
            SauceLabsIntegration.setSauceLabsOption(desiredCapabilities, "tunnelIdentifier", tunnelId);
        }
    }

    public static void setSauceLabsOption(DesiredCapabilities desiredCapabilities, String key, Object value) {
        HashMap<String, Object> sauceOptions = new HashMap<String, Object>();
        Map<String, Object> currentOptions = SauceLabsIntegration.getSauceLabsOptions(desiredCapabilities);
        if (currentOptions != null) {
            sauceOptions.putAll(currentOptions);
        }
        sauceOptions.put(key, value);
        desiredCapabilities.setCapability("sauce:options", sauceOptions);
    }

    private static Map<String, Object> getSauceLabsOptions(DesiredCapabilities desiredCapabilities) {
        return (Map)desiredCapabilities.getCapability("sauce:options");
    }

    public static Object getSauceLabsOption(DesiredCapabilities desiredCapabilities, String key) {
        Map<String, Object> sauceOptions = SauceLabsIntegration.getSauceLabsOptions(desiredCapabilities);
        if (sauceOptions == null) {
            return null;
        }
        return sauceOptions.get(key);
    }

    public static String getSauceTunnelIdentifier() {
        String tunnelId = SauceLabsIntegration.getSystemPropertyOrEnv(SAUCE_TUNNELID_PROP, SAUCE_TUNNELID_ENV);
        if (tunnelId == null) {
            String sauceOptions = System.getProperty("sauce.options");
            tunnelId = SauceLabsIntegration.getTunnelIdentifierFromOptions(sauceOptions);
        }
        return tunnelId;
    }

    private static String getTunnelIdentifierFromOptions(String options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        Iterator<String> tokensIterator = Arrays.asList(options.split(" ")).iterator();
        while (tokensIterator.hasNext()) {
            String currentToken = tokensIterator.next();
            if (!tokensIterator.hasNext() || !currentToken.equals("-i") && !currentToken.equals("--tunnel-identifier")) continue;
            return tokensIterator.next();
        }
        return null;
    }

    public static String getHubUrl() {
        String hubUrl = SauceLabsIntegration.getSystemPropertyOrEnv(SAUCE_HUB_URL_PROP, SAUCE_HUB_URL_ENV);
        if (hubUrl == null) {
            hubUrl = SAUCE_DEFAULT_HUB_URL;
        }
        return hubUrl;
    }

    public static boolean isConfiguredForSauceLabs() {
        String user = SauceLabsIntegration.getSauceUser();
        String accessKey = SauceLabsIntegration.getSauceAccessKey();
        return user != null && !user.isEmpty() && accessKey != null && !accessKey.isEmpty();
    }

    public static String getSauceUser() {
        return SauceLabsIntegration.getSystemPropertyOrEnv(SAUCE_USERNAME_PROP, SAUCE_USERNAME_ENV);
    }

    public static String getSauceAccessKey() {
        return SauceLabsIntegration.getSystemPropertyOrEnv(SAUCE_ACCESS_KEY_PROP, SAUCE_ACCESS_KEY_ENV);
    }

    private static String getSystemPropertyOrEnv(String propertyKey, String envName) {
        String env = System.getenv(envName);
        String prop = System.getProperty(propertyKey);
        return prop != null ? prop : env;
    }

    public static interface CapabilityType {
        public static final String NAME = "name";
    }
}

